<?php
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.2【日本語版】
// opencart.jp
// rakuten_easy.php Cntroller Ctalog
// ver 1.0.0 Coding By sae  2010/10/25 seagreenzzz@gmail.com
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
class ControllerPaymentRakutenEasy extends Controller{

	protected function index(){
		//言語ファイルのロード
		$this->load->language('payment/rakuten_easy');

		//モデルのロード
		$this->load->model('checkout/order');

		//注文情報の取得
		$order = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		//送信先を変数に格納
		$this->data['rakuten_easy_send_url'] = $this->config->get('rakuten_easy_send_url') . '&AMT=' . $order['total'];

		//サンクスページ
		$this->data['continue'] = HTTPS_SERVER . 'index.php?route=checkout/success';
		//ボタンの表示文言
		//注文を確定ボタン
		$this->data['button_confirm'] = $this->language->get('button_confirm');
		//戻るボタン
		$this->data['button_back'] = $this->language->get('button_back');

		//「戻る」ボタンの戻り先URL（ゲスト購入の場合と会員購入の場合とでは異なる）
		if ($this->request->get['route'] != 'checkout/guest_step_3') {
			$this->data['back'] = HTTPS_SERVER . 'index.php?route=checkout/payment';
		} else {
			$this->data['back'] = HTTPS_SERVER . 'index.php?route=checkout/guest_step_2';
		}

		//ＩＤ
		$this->id = 'payment';

		//テンプレートファイル
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/rakuten_easy.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/payment/rakuten_easy.tpl';
		} else {
			$this->template = 'default/template/payment/rakuten_easy.tpl';
		}

		$this->render();

	}

	//注文を確定ボタンをクリックした場合に使用するＵＲＬ
	public function confirm() {
		$this->load->model('checkout/order');

		$this->model_checkout_order->confirm($this->session->data['order_id'], $this->config->get('rakuten_easy_order_status_id'));
	}

}
?>