<?php
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.9【日本語版】
// opencart.jp
// remise.php
// ver 1.0.0 Coding By sae  2010/03/21 seagreenzzz@gmail.com
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
class ControllerPaymentRemise extends Controller {

	protected function index() {
    	$this->language->load('payment/remise');
		//送信先を変数に格納
		$this->data['url_pc'] = $this->config->get('remise_url_pc');
		$this->data['url_mob'] = $this->config->get('remise_url_mob');


		//注文内容を取得
		$this->load->model('checkout/order');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		$this->data['payment_data'] = array(
			'SHOPCO'         => $this->config->get('remise_store_code'),
			'HOSTID'         => $this->config->get('remise_host_no'),
			'S_TORIHIKI_NO'  =>   $order_info['order_id'],
			'JOB'            => 'CAPTURE',
			'ITEM'           => $this->config->get('remise_product_code'),
			'AMOUNT'         => (int)$order_info['total'],
			'TAX'            => '0',
			'TOTAL'          => (int)$order_info['total'],
			'MAIL'           => $order_info['email'],
			'RETURL'         => HTTPS_SERVER . 'index.php?route=payment/remise/confirm'
		);

		$this->load->model('payment/remise');

		$payquick_id = $this->model_payment_remise->getPayQuickId();

		if( $this->config->get('remise_payquick') == 1 && isset($this->session->data['customer_id'])){

			$this->data['payment_data']['PAYQUICK'] = $this->config->get('remise_payquick');

		}

		if( $this->config->get('remise_payquick') == 1 && !empty($payquick_id) && isset($this->session->data['customer_id']) ){

			$this->data['payment_data']['PAYQUICKID'] = $payquick_id;

		}

		//ボタンの表示文言
		$this->data['button_confirm'] = $this->language->get('button_confirm');
		$this->data['button_back'] = $this->language->get('button_back');

		//「戻る」ボタンの戻り先URL（ゲスト購入の場合と会員購入の場合とでは異なる）
		if ($this->request->get['route'] != 'checkout/guest_step_3') {
			$this->data['back'] = HTTPS_SERVER . 'index.php?route=checkout/payment';
		} else {
			$this->data['back'] = HTTPS_SERVER . 'index.php?route=checkout/guest_step_2';
		}

		//ID
		$this->id = 'payment';

		//テンプレートファイル呼び出し
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/remise.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/payment/remise.tpl';
		} else {
			$this->template = 'default/template/payment/remise.tpl';
		}

		$this->render();
	}

	public function confirm() {
		if( isset($this->request->post['X-TRANID']) && $this->session->data['order_id'] == $this->request->post['X-S_TORIHIKI_NO'] ){
			//モデルのロード
			$this->load->model('checkout/order');
			//注文状態をデータベースに登録
			$this->model_checkout_order->confirm($this->session->data['order_id'], $this->config->get('remise_order_status_id'));

			//サンクスぺージにリダイレクト
			$this->redirect( HTTP_SERVER . 'index.php?route=checkout/success' );

		}

	}

	public function remise_result(){

		if( isset($this->request->post['X-TRANID']) ){

			$this->load->model('payment/remise');

			$checkorder = $this->model_payment_remise->checkPayQuickId($this->request->post['X-S_TORIHIKI_NO']);


			if( isset($this->request->post['X-PAYQUICKID']) && $this->config->get('remise_payquick') == 1 && $checkorder ){

				$this->load->model('payment/remise');

				$payquick_id = $this->model_payment_remise->getPayQuickId();

				if(empty($payquick_id) && $checkorder ){

					$this->model_payment_remise->addPayQuickId( $this->request->post['X-PAYQUICKID'] );

				}

			}

			//成功時のレスポンスを返す
			die('<SDBKDATA>STATUS=800</SDBKDATA>');

		}else{

			//失敗の時もレスポンスを返さなくてはならない！！（ルミーズ特有）
			die('<SDBKDATA>STATUS=800</SDBKDATA>');

		}
	}

}
?>