/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.URLConnect;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.common.SystemParameter;

public class HybsContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        Map<String, String> map = SystemParameter.makeSystemParameter(servletContext);
        HybsSystem.setInitialData(map);
        LogWriter.init((String)HybsSystem.url2dir(System.getProperty("SYS_LOG_URL", HybsSystem.sys("SYS_LOG_URL"))));
        new Thread(new InitialCallURL()).start();
        System.out.println("-------");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        String string = HybsSystem.sys("CONTEXT_NAME");
        System.out.println("Context Destroyed [" + string + "]  " + new Date());
        SystemManager.clearGE12();
        SystemManager.allClear(true);
        SystemManager.sofficeKill();
        SystemManager.sessionDestroyed();
        System.out.println("-------");
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                ConnectionFactory.realClose();
            }
        };
        SystemManager.addCleanable(cleanable);
    }

    private static class InitialCallURL
    implements Runnable {
        private InitialCallURL() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                LogWriter.log((String)("InterruptedException:" + interruptedException.getMessage()));
            }
            HybsEntry[] hybsEntryArray = HybsSystem.sysEntry("CONTEXT_INITIAL_CALL_URL");
            String string = HybsSystem.sys("CONTEXT_INITIAL_CALL_USERPASS");
            boolean bl = false;
            for (int i = 0; i < hybsEntryArray.length; ++i) {
                String string2 = hybsEntryArray[i].getValue();
                if (string2 == null || string2.length() == 0) continue;
                URLConnect uRLConnect = new URLConnect(string2, string);
                try {
                    uRLConnect.connect();
                    String string3 = uRLConnect.getCode() + ":" + uRLConnect.getMessage();
                    uRLConnect.disconnect();
                    System.out.println("    URL[" + i + "]:" + string2);
                    System.out.println("           " + string3);
                    bl = true;
                    continue;
                }
                catch (IOException iOException) {
                    LogWriter.log((String)("    URL[" + i + "]:" + string2));
                    LogWriter.log((String)("           " + iOException.getMessage()));
                }
            }
            if (bl) {
                System.out.println("  CONTEXT_INITIAL_CALL_URL");
                System.out.println("-------");
            }
        }
    }
}

