/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.CalendarData;
import org.opengion.hayabusa.resource.CalendarFactory;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class GanttHeaderTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private String startDate = null;
    private String endDate = null;
    private String daySpan = "0700-2000";
    private int zoom = 2;
    private String breakTimes = null;
    private String breakTimeStyle = "top:20px;background-color:yellow;";
    private String calDB = null;
    private String arg1 = null;
    private String arg2 = null;
    private String arg3 = null;
    private String arg4 = null;
    private boolean skipHoliday = HybsSystem.sysBool("USE_GANTTHEADER_SKIP_HOLIDAY");
    private static final int TIME_PIXEL = 48;
    private static final boolean USE_MULTI_CLM = HybsSystem.sysBool("USE_GANTTHEADER_MULTIPLE_COLUMN");
    private static final boolean USE_MONTH_DATE = HybsSystem.sysBool("USE_GANTTHEADER_MONTH_DATE");
    private static final int MONTH_DATE_LIMITER = 20;
    private static final String BLUE_COLOR = "<span style=\"color:Blue;\">";
    private static final String RED_COLOR = "<span style=\"color:Red;\">";
    private static final String END_SPAN = "</span>";
    private static final String BR = "<br/>";

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.startDate == null || this.endDate == null || this.startDate.length() < 8 || this.endDate.length() < 8) {
            String string = "\u958b\u59cb\u65e5\u3068\u7d42\u4e86\u65e5\u306f\u3001\u3069\u3061\u3089\u3082 yyyyMMdd \u5f62\u5f0f\u3067\u3001\u5fc5\u9808\u3067\u3059\u3002 startDate=[" + this.startDate + "] endDate=[" + this.endDate + "]";
            throw new HybsSystemException(string);
        }
        String string = "";
        String string2 = USE_MONTH_DATE ? "MM   " : "MM/dd";
        switch (this.zoom) {
            case 0: {
                string = this.makeZoom("MM/   ", "dd(EE)", 1, false);
                break;
            }
            case 1: {
                string = this.makeZoom("MM/", "dd ", 1, false);
                break;
            }
            case 2: {
                string = this.makeZoom2(1);
                break;
            }
            case 3: {
                string = this.makeZoom("yyyy/  ", "MM/dd  ", 7, false);
                break;
            }
            case 4: {
                string = this.makeZoom("yyyy/  ", "MM/dd  ", 14, false);
                break;
            }
            case 5: {
                string = this.makeZoom("yyyy/     ", string2 + "     ", 30, USE_MONTH_DATE);
                break;
            }
            case 6: {
                string = this.makeZoom("yyyy/ ", string2 + " ", 30, USE_MONTH_DATE);
                break;
            }
            case 7: {
                string = this.makeZoom("yyyy/     ", string2 + "     ", 90, USE_MONTH_DATE);
                break;
            }
            case 8: {
                string = this.makeZoom("yyyy/     ", string2 + "     ", 180, USE_MONTH_DATE);
                break;
            }
            case 9: {
                string = this.makeZoom("yyyy/ ", string2 + " ", 180, USE_MONTH_DATE);
                break;
            }
            case 10: {
                string = this.makeZoom("ww'W'", "'<span title=\"'MM/dd'\">'dd '</span>'", 7, false);
                break;
            }
            case 20: {
                string = this.makeZoomTime(48, 1, true);
                break;
            }
            case 21: {
                string = this.makeZoomTime(24, 1, false);
                break;
            }
            case 22: {
                string = this.makeZoomTime(48, 2, true);
                break;
            }
            case 23: {
                string = this.makeZoomTime(24, 2, false);
                break;
            }
            case 24: {
                string = this.makeZoomTime(48, 4, true);
                break;
            }
            case 25: {
                string = this.makeZoomTime(24, 4, false);
                break;
            }
            case 26: {
                string = this.makeZoomTime(48, 6, true);
                break;
            }
            case 27: {
                string = this.makeZoomTime(24, 6, false);
                break;
            }
            case 28: {
                string = this.makeZoomTime(48, 8, true);
                break;
            }
            case 29: {
                string = this.makeZoomTime(24, 8, false);
                break;
            }
            case 30: {
                string = this.makeZoomTime(48, 12, true);
                break;
            }
            case 31: {
                string = this.makeZoomTime(24, 12, false);
                break;
            }
        }
        this.jspPrint(string);
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.startDate = null;
        this.endDate = null;
        this.zoom = 2;
        this.calDB = null;
        this.arg1 = null;
        this.arg2 = null;
        this.arg3 = null;
        this.arg4 = null;
        this.daySpan = "0700-2000";
        this.breakTimes = null;
        this.breakTimeStyle = "top:20px;background-color:yellow;";
        this.skipHoliday = HybsSystem.sysBool("USE_GANTTHEADER_SKIP_HOLIDAY");
    }

    private String makeZoom(String string, String string2, int n, boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2, Locale.JAPAN);
        Calendar calendar = HybsSystem.getCalendar(this.startDate);
        Calendar calendar2 = HybsSystem.getCalendar(this.endDate);
        if (this.zoom == 10) {
            calendar.setMinimalDaysInFirstWeek(7);
            simpleDateFormat.setCalendar(calendar);
            simpleDateFormat2.setCalendar(calendar);
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        StringBuilder stringBuilder2 = new StringBuilder(50);
        CalendarData calendarData = CalendarFactory.getCalendarData(this.calDB, this.arg1, this.arg2, this.arg3, this.arg4);
        boolean bl2 = false;
        while (calendar.before(calendar2)) {
            Date date = calendar.getTime();
            if (bl && calendar.get(5) >= 20) {
                Calendar calendar3 = (Calendar)calendar.clone();
                calendar3.set(5, 1);
                calendar3.add(2, 1);
                date = calendar3.getTime();
            }
            if (calendarData.isContainedToday(calendar, n)) {
                stringBuilder.append(BLUE_COLOR);
                stringBuilder2.append(BLUE_COLOR);
                bl2 = true;
            }
            if (!bl2 && n == 1 && calendarData.isHoliday(calendar)) {
                stringBuilder.append(RED_COLOR);
                stringBuilder2.append(RED_COLOR);
                bl2 = true;
            }
            stringBuilder.append(simpleDateFormat.format(date));
            stringBuilder2.append(simpleDateFormat2.format(date));
            if (bl2) {
                stringBuilder.append(END_SPAN);
                stringBuilder2.append(END_SPAN);
                bl2 = false;
            }
            calendar.add(5, n);
        }
        return "<pre>" + stringBuilder.toString() + BR + stringBuilder2.toString() + "</pre>";
    }

    private String makeZoom2(int n) {
        Calendar calendar = HybsSystem.getCalendar(this.startDate);
        Calendar calendar2 = HybsSystem.getCalendar(this.endDate);
        StringBuilder stringBuilder = new StringBuilder(50);
        StringBuilder stringBuilder2 = new StringBuilder(50);
        StringBuilder stringBuilder3 = new StringBuilder(50);
        StringBuilder stringBuilder4 = new StringBuilder(50);
        StringBuilder stringBuilder5 = new StringBuilder(50);
        CalendarData calendarData = CalendarFactory.getCalendarData(this.calDB, this.arg1, this.arg2, this.arg3, this.arg4);
        boolean bl = false;
        while (calendar.before(calendar2)) {
            boolean bl2;
            int n2 = calendar.get(2) + 1;
            int n3 = calendar.get(5);
            boolean bl3 = bl2 = 2 == calendar.get(7);
            if (calendarData.isContainedToday(calendar, n)) {
                stringBuilder.append(BLUE_COLOR);
                stringBuilder2.append(BLUE_COLOR);
                stringBuilder3.append(BLUE_COLOR);
                stringBuilder4.append(BLUE_COLOR);
                stringBuilder5.append(BLUE_COLOR);
                bl = true;
            }
            if (!bl && n == 1 && calendarData.isHoliday(calendar)) {
                stringBuilder.append(RED_COLOR);
                stringBuilder2.append(RED_COLOR);
                stringBuilder3.append(RED_COLOR);
                stringBuilder4.append(RED_COLOR);
                stringBuilder5.append(RED_COLOR);
                bl = true;
            }
            if (bl2) {
                stringBuilder.append(n2 / 10);
                stringBuilder2.append(n2 % 10);
                stringBuilder3.append("/");
            } else {
                stringBuilder.append(" ");
                stringBuilder2.append(" ");
                stringBuilder3.append(" ");
            }
            stringBuilder4.append(n3 / 10);
            stringBuilder5.append(n3 % 10);
            if (bl) {
                stringBuilder.append(END_SPAN);
                stringBuilder2.append(END_SPAN);
                stringBuilder3.append(END_SPAN);
                stringBuilder4.append(END_SPAN);
                stringBuilder5.append(END_SPAN);
                bl = false;
            }
            calendar.add(5, n);
        }
        stringBuilder.append(BR).append((CharSequence)stringBuilder2);
        stringBuilder.append(BR).append((CharSequence)stringBuilder3);
        stringBuilder.append(BR).append((CharSequence)stringBuilder4);
        stringBuilder.append(BR).append((CharSequence)stringBuilder5);
        return "<pre>" + stringBuilder.toString() + "</pre>";
    }

    private String makeZoomTime(int n, int n2, boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd", Locale.JAPAN);
        StringBuilder stringBuilder = new StringBuilder(50);
        StringBuilder stringBuilder2 = new StringBuilder(50);
        StringBuilder stringBuilder3 = new StringBuilder(50);
        int n3 = GanttHeaderTag.ym2int(this.daySpan.substring(0, 2), this.daySpan.substring(2, 4));
        int n4 = GanttHeaderTag.ym2int(this.daySpan.substring(5, 7), this.daySpan.substring(7));
        if (n4 <= n3) {
            n4 += 2400;
        }
        BreakTimes breakTimes = new BreakTimes(n / n2, this.breakTimes, this.breakTimeStyle, n3, n4);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 5);
        int n5 = calendar.get(11);
        boolean bl2 = this.isDebug();
        if (bl2) {
            System.out.println("startDate=" + this.startDate);
            System.out.println("endDate  =" + this.endDate);
        }
        Calendar calendar2 = HybsSystem.getCalendar(this.startDate);
        Calendar calendar3 = HybsSystem.getCalendar(this.endDate);
        CalendarData calendarData = CalendarFactory.getCalendarData(this.calDB, this.arg1, this.arg2, this.arg3, this.arg4);
        int n6 = (int)((double)(n / n2 * (n4 - n3)) / 100.0);
        int n7 = 0;
        int n8 = (int)((double)(n / n2 * (n3 - (int)((double)(calendar2.get(11) * 100) + (double)calendar2.get(12) * 10.0 / 6.0))) / 100.0);
        String string = bl ? (USE_MULTI_CLM ? "  " : "h ") : "";
        boolean bl3 = false;
        int n9 = 0;
        while (calendar2.before(calendar3)) {
            int n10;
            if (bl2) {
                System.out.println("Calendar str =" + calendar2.getTime());
            }
            if (calendarData.isHoliday(calendar2) && this.skipHoliday) {
                if (bl2) {
                    System.out.println("Holiday =" + calendar2.getTime());
                }
                calendar2.add(5, 1);
                continue;
            }
            String string2 = "class=\"GNT_" + n9++ % 2 + "\"";
            Date date = calendar2.getTime();
            String string3 = simpleDateFormat.format(date);
            stringBuilder.append("<span ").append(string2);
            stringBuilder.append(" title=\"").append(string3).append("\">");
            if (bl2) {
                System.out.println("title =" + string3);
            }
            boolean bl4 = calendarData.isContainedToday(calendar2, 1);
            int n11 = n10 = n3 / 100;
            boolean bl5 = false;
            for (int i = n3; i < n4; i += 100) {
                Object object;
                if (bl2) {
                    System.out.println("hour =" + i);
                    System.out.println("tmHd =" + n10);
                }
                boolean bl6 = bl5 = bl5 || bl4 && n10 == n5;
                if ((n11 - n10) % n2 != 0) {
                    ++n10;
                    continue;
                }
                if (n10 >= 24) {
                    n10 = 0;
                    object = new Date(calendar2.getTimeInMillis() + 86400000L);
                    string3 = simpleDateFormat.format((Date)object);
                    stringBuilder.append("</span><span ").append(string2);
                    stringBuilder.append(" title=\"").append(string3).append("\">");
                }
                if (bl5) {
                    stringBuilder.append(BLUE_COLOR);
                    stringBuilder3.append(BLUE_COLOR);
                    bl3 = true;
                    bl5 = false;
                } else if (calendarData.isHoliday(calendar2) && !this.skipHoliday) {
                    stringBuilder.append(RED_COLOR);
                    stringBuilder3.append(RED_COLOR);
                    bl3 = true;
                }
                object = breakTimes.makeSpan(n7 * n6 - n8, calendar2, i, n2);
                if (object != null) {
                    stringBuilder2.append((String)object);
                }
                if (n10 < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n10).append(string);
                if (USE_MULTI_CLM) {
                    if ((n11 - n10) % 6 == 0) {
                        if (bl) {
                            stringBuilder3.append(string3.substring(8)).append("\u65e5");
                        } else {
                            stringBuilder3.append(string3.substring(8));
                        }
                    } else if (bl) {
                        stringBuilder3.append("    ");
                    } else {
                        stringBuilder3.append("  ");
                    }
                }
                if (bl3) {
                    stringBuilder.append(END_SPAN);
                    stringBuilder3.append(END_SPAN);
                    bl3 = false;
                }
                ++n10;
            }
            calendar2.add(5, 1);
            ++n7;
            stringBuilder.append(END_SPAN);
            stringBuilder3.append(END_SPAN);
        }
        stringBuilder2.append("<pre>");
        stringBuilder.append("</pre>");
        if (USE_MULTI_CLM) {
            stringBuilder2.append(stringBuilder3.toString()).append("<br />");
        }
        return stringBuilder2.append(stringBuilder.toString()).toString();
    }

    public void setStartDate(String string) {
        this.startDate = StringUtil.nval((String)this.getRequestParameter(string), (String)this.startDate);
    }

    public void setEndDate(String string) {
        this.endDate = StringUtil.nval((String)this.getRequestParameter(string), (String)this.endDate);
    }

    public void setDaySpan(String string) {
        this.daySpan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.daySpan);
        if (this.daySpan.length() != 9 || this.daySpan.charAt(4) != '-') {
            String string2 = "\uff11\u65e5\u306e\u958b\u59cb\u7d42\u4e86\u6642\u9593\u306f24\u6642\u9593\u5236\u3067(HHmm-HHmm)\u5f62\u5f0f\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 daySpan=[" + this.daySpan + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setZoom(String string) {
        this.zoom = StringUtil.nval((String)this.getRequestParameter(string), (int)this.zoom);
    }

    public void setCalDB(String string) {
        this.calDB = StringUtil.nval((String)this.getRequestParameter(string), (String)this.calDB);
    }

    public void setBreakTimeStyle(String string) {
        this.breakTimeStyle = StringUtil.nval((String)this.getRequestParameter(string), (String)this.breakTimeStyle);
    }

    public void setBreakTimes(String string) {
        this.breakTimes = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setArg1(String string) {
        this.arg1 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.arg1);
    }

    public void setArg2(String string) {
        this.arg2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.arg2);
    }

    public void setArg3(String string) {
        this.arg3 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.arg3);
    }

    public void setArg4(String string) {
        this.arg4 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.arg4);
    }

    public void setSkipHoliday(String string) {
        this.skipHoliday = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.skipHoliday);
    }

    private static int ym2int(String string, String string2) {
        return (int)((double)(Integer.parseInt(string) * 100) + (double)Integer.parseInt(string2) * 10.0 / 6.0);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("startDate", (Object)this.startDate).println("endDate", (Object)this.endDate).println("daySpan", (Object)this.daySpan).println("zoom", (Object)this.zoom).println("breakTimes", (Object)this.breakTimes).println("breakTimeStyle", (Object)this.breakTimeStyle).println("calDB", (Object)this.calDB).println("arg1", (Object)this.arg1).println("arg2", (Object)this.arg2).println("arg3", (Object)this.arg3).println("arg4", (Object)this.arg4).println("skipHoliday", (Object)this.skipHoliday).println("TIME_PIXEL", (Object)48).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private static class BreakTimes {
        private final List<BreakTimeData> timeList = new ArrayList<BreakTimeData>();
        private final int hourOfPixcel;
        private final String breakTimeStyle;
        private final int viewStartTime;
        private final int viewEndTime;

        BreakTimes(int n, String string, String string2, int n2, int n3) {
            this.hourOfPixcel = n;
            this.breakTimeStyle = string2 == null ? "" : string2;
            this.viewStartTime = n2;
            this.viewEndTime = n3;
            boolean bl = this.viewEndTime > 2400;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.JAPAN);
            for (String string3 : StringUtil.csv2Array((String)string)) {
                Object object;
                int n4;
                int n5;
                String string4;
                String string5;
                if (string3 == null) continue;
                if (string3.length() == 9 && string3.charAt(4) == '-') {
                    string5 = null;
                    string4 = null;
                    n5 = GanttHeaderTag.ym2int(string3.substring(0, 2), string3.substring(2, 4));
                    n4 = GanttHeaderTag.ym2int(string3.substring(5, 7), string3.substring(7));
                } else if (string3.length() == 17 && string3.charAt(12) == '-') {
                    string5 = string3.substring(0, 8);
                    string4 = null;
                    n5 = GanttHeaderTag.ym2int(string3.substring(8, 10), string3.substring(10, 12));
                    n4 = GanttHeaderTag.ym2int(string3.substring(13, 15), string3.substring(15));
                } else if (string3.length() == 25 && string3.charAt(12) == '-') {
                    string5 = string3.substring(0, 8);
                    string4 = string3.substring(13, 21);
                    n5 = GanttHeaderTag.ym2int(string3.substring(8, 10), string3.substring(10, 12));
                    n4 = GanttHeaderTag.ym2int(string3.substring(21, 23), string3.substring(23));
                } else {
                    object = "\u4f11\u61a9\u6642\u9593\u306f\u3001HHmm-HHmm\u5f62\u5f0f\u3001\u307e\u305f\u306f\u3001yyyyMMddHHmm-HHmm\u3001\u307e\u305f\u306f\u3001yyyyMMddHHmm-yyyyMMddHHmm\u5f62\u5f0f\u3067\u3059\u3002" + HybsSystem.CR + "breakTimes=[" + string + "] Bad=[" + string3 + "]";
                    throw new HybsSystemException((String)object);
                }
                Calendar calendar = null;
                Calendar calendar2 = null;
                if (string5 != null) {
                    calendar = HybsSystem.getCalendar(string5);
                }
                if (string4 != null) {
                    calendar2 = HybsSystem.getCalendar(string4);
                }
                if (bl) {
                    if (n5 < this.viewEndTime - 2400) {
                        if (calendar != null) {
                            calendar.add(5, -1);
                            string5 = simpleDateFormat.format(calendar.getTime());
                        }
                        n5 += 2400;
                    }
                    if (n4 <= this.viewEndTime - 2400) {
                        if (calendar2 != null) {
                            calendar2.add(5, -1);
                            string4 = simpleDateFormat.format(calendar2.getTime());
                        }
                        n4 += 2400;
                    }
                }
                if (n5 < this.viewStartTime) {
                    n5 = this.viewStartTime;
                }
                if (n5 > this.viewEndTime) {
                    n5 = this.viewEndTime;
                }
                if (n4 < this.viewStartTime) {
                    n4 = this.viewStartTime;
                }
                if (n4 > this.viewEndTime) {
                    n4 = this.viewEndTime;
                }
                int n6 = n4 - n5;
                String string6 = string3;
                if (n6 >= 0 && (string4 == null || string5 != null && string5.equals(string4))) {
                    n6 = n4 - n5;
                    this.timeList.add(new BreakTimeData(string5, n5, n6, string6));
                    continue;
                }
                n6 = this.viewEndTime - n5;
                this.timeList.add(new BreakTimeData(string5, n5, n6, string6));
                n6 = n4 - this.viewStartTime;
                this.timeList.add(new BreakTimeData(string4, this.viewStartTime, n6, string6));
                n6 = this.viewEndTime - this.viewStartTime;
                if (calendar == null || calendar2 == null) continue;
                calendar.add(5, 1);
                while (calendar.before(calendar2)) {
                    object = calendar.getTime();
                    String string7 = simpleDateFormat.format((Date)object);
                    this.timeList.add(new BreakTimeData(string7, this.viewStartTime, n6, string6));
                    calendar.add(5, 1);
                }
            }
        }

        String makeSpan(int n, Calendar calendar, int n2, int n3) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.JAPAN);
            String string = simpleDateFormat.format(calendar.getTime());
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = this.timeList.size();
            for (int i = 0; i < n4; ++i) {
                BreakTimeData breakTimeData = this.timeList.get(i);
                if (!breakTimeData.startsWith(string, n2, n3)) continue;
                stringBuilder.append(breakTimeData.getBreakTime(n, this.hourOfPixcel, this.breakTimeStyle));
            }
            String string2 = null;
            if (stringBuilder.length() > 0) {
                string2 = stringBuilder.toString();
            }
            return string2;
        }
    }

    private static class BreakTimeData {
        private final String startDay;
        private final int startTime;
        private final int timeSpan;
        private final String viewTime;

        BreakTimeData(String string, int n, int n2, String string2) {
            this.startDay = string;
            this.startTime = n;
            this.timeSpan = n2;
            this.viewTime = string2;
        }

        boolean startsWith(String string, int n, int n2) {
            return this.timeSpan > 0 && n <= this.startTime && this.startTime < n + 100 * n2 && (this.startDay == null || string.equals(this.startDay));
        }

        String getBreakTime(int n, int n2, String string) {
            int n3 = n + this.startTime * n2 / 100;
            int n4 = this.timeSpan * n2 / 100;
            return "<span class=\"breaktime\" title=\"" + this.viewTime + "\"" + " style=\"position:absolute;z-index:100;height:500000px;" + "left:" + n3 + "px;" + "width:" + n4 + "px;" + string + "\" ></span>" + HybsSystem.CR;
        }
    }
}

