/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.LogWriter;

public class Process_DBCountFilter
extends AbstractProcess
implements ChainProcess {
    private Connection connection = null;
    private PreparedStatement pstmt = null;
    private String dbid = null;
    private String sql = null;
    private int cntFlag = -2;
    private boolean display = false;
    private int[] clmNos = null;
    private boolean firstRow = true;
    private int count = 0;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty;

    public Process_DBCountFilter() {
        super("org.opengion.fukurou.process.Process_DBCountFilter", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.sql = argument.getFileProparty("sql", "sqlFile", true);
        this.cntFlag = argument.getProparty("count", this.cntFlag);
        this.display = argument.getProparty("display", this.display);
        this.dbid = argument.getProparty("dbid");
        this.connection = paramProcess.getConnection(this.dbid);
    }

    @Override
    public void end(boolean bl) {
        boolean bl2 = Closer.stmtClose(this.pstmt);
        this.pstmt = null;
        ConnectionFactory.remove(this.connection, this.dbid);
        if (!bl2) {
            String string = "\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LineModel action(LineModel lineModel) {
        LineModel lineModel2 = lineModel;
        ++this.count;
        try {
            int n;
            if (this.firstRow) {
                this.pstmt = this.makePrepareStatement(lineModel);
                this.firstRow = false;
            }
            for (n = 0; n < this.clmNos.length; ++n) {
                this.pstmt.setObject(n + 1, lineModel.getValue(this.clmNos[n]));
            }
            n = -1;
            ResultSet resultSet = null;
            try {
                resultSet = this.pstmt.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            }
            finally {
                Closer.resultClose(resultSet);
            }
            if (n > 2 && this.cntFlag != 2 || n <= 2 && n != this.cntFlag) {
                lineModel2 = null;
            }
            if (this.display) {
                this.printKey(this.count, n, lineModel);
            }
        }
        catch (SQLException sQLException) {
            String string = "sql=[" + this.sql + "]" + CR + "errorCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR;
            throw new RuntimeException(string, sQLException);
        }
        return lineModel2;
    }

    private PreparedStatement makePrepareStatement(LineModel lineModel) {
        PreparedStatement preparedStatement;
        Formatter formatter = new Formatter(lineModel);
        formatter.setFormat(this.sql);
        this.sql = formatter.getQueryFormatString();
        this.clmNos = formatter.getClmNos();
        try {
            preparedStatement = this.connection.prepareStatement(this.sql);
        }
        catch (SQLException sQLException) {
            String string = "PreparedStatement \u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "sql=[" + this.sql + "]" + CR + "nameLine=[" + lineModel.nameLine() + "]";
            throw new RuntimeException(string, sQLException);
        }
        return preparedStatement;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "DBID         : " + this.dbid + CR + "\t" + "Output Count : " + this.count;
        return string;
    }

    private void printKey(int n, int n2, LineModel lineModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("row=[").append(n).append("] : ");
        stringBuilder.append("count=[").append(n2).append("] ");
        for (int i = 0; i < this.clmNos.length; ++i) {
            if (i == 0) {
                stringBuilder.append("where ");
            } else {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(lineModel.getName(this.clmNos[i]));
            stringBuilder.append(" = ");
            stringBuilder.append(lineModel.getValue(this.clmNos[i]));
        }
        this.println(stringBuilder.toString());
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_DBCountFilter \u306f\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u5b58\u5728\u4ef6\u6570\u3067\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u3059\u308b").append(CR);
        stringBuilder.append("ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append("\u4e0a\u6d41\uff08\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002\uff09\u304b\u3089").append(CR);
        stringBuilder.append("\u53d7\u3051\u53d6\u3063\u305f LineModel \u3092\u5143\u306b\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u5b58\u5728\u30c1\u30a7\u30c3\u30af\u3092\u884c\u3044\u3001").append(CR);
        stringBuilder.append("\u4e0b\u6d41\u3078\u306e\u51e6\u7406\u3092\u632f\u308a\u5206\u3051\u307e\u3059\u3002").append(CR);
        stringBuilder.append("\u5b58\u5728\u30c1\u30a7\u30c3\u30af\u3067\u6307\u5b9a\u3059\u308b SELECT \u6587\u306f\u3001\u5fc5\u305a\u3001\u300eselect count(*) from \uff65\uff65\uff65\u300f").append(CR);
        stringBuilder.append("\u5f62\u5f0f\u306b\u3057\u3066\u4e0b\u3055\u3044\u3002\u691c\u7d22\u30ab\u30e9\u30e0\u306f\u3001\u4e00\u3064\u3060\u3051\u3067\u3001\u305d\u3053\u306b\u306f\u6570\u5b57\u304c\u5165\u308a\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5148\u7b49\u306f\u3001ParamProcess \u306e\u30b5\u30d6\u30af\u30e9\u30b9(Process_DBParam)\u306b").append(CR);
        stringBuilder.append("\u8a2d\u5b9a\u3055\u308c\u305f\u63a5\u7d9a(Connection)\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("-url_XXXX \u3067\u6307\u5b9a\u3055\u308c\u305f XXXX \u304c\u3001-dbid=XXXX \u306b\u5bfe\u5fdc\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_DBCountFilter().usage());
    }

    static {
        mustProparty.put("dbid", "DB\u63a5\u7d9aID(\u5fc5\u9808) \u4f8b: ParamProcess \u306e -url_XXXX \u3067\u6307\u5b9a\u3055\u308c\u305f XXXX");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("sql", "\u30ab\u30a6\u30f3\u30c8SQL\u6587\uff08sql or sqlFile \u5fc5\u9808\uff09" + CR + "\u4f8b: \"SELECT COUNT(*) FROM GEA03 " + CR + "WHERE SYSTEM_ID = [SYSTEM_ID] " + CR + "AND CLM = [CLM] AND FGJ = '1'\"");
        usableProparty.put("sqlFile", "\u691c\u7d22SQL\u30d5\u30a1\u30a4\u30eb\uff08sql or sqlFile \u5fc5\u9808\uff09\u4f8b: select.sql");
        usableProparty.put("count", "[0|1|2] \u306f\u3001\u691c\u7d22\u5024\u306b\u5fdc\u3058\u305f\u30b9\u30eb\u30fc\u6761\u4ef6" + CR + "  0:\uff10\u4ef6\u6642\u306b\u30b9\u30eb\u30fc(\u51e6\u7406\u3092\u7d99\u7d9a) \u3064\u307e\u308a\u3001\u306a\u3051\u308c\u3070\u7d99\u7d9a" + CR + "  1:\uff11\u4ef6\u6642\u306b\u30b9\u30eb\u30fc(\u51e6\u7406\u3092\u7d99\u7d9a) \u3064\u307e\u308a\u3001\u3042\u308c\u3070\u7d99\u7d9a" + CR + "  2:\uff12\u4ef6\u4ee5\u4e0a\u3042\u308b\u5834\u5408\u306b\u30b9\u30eb\u30fc   \u3064\u307e\u308a\u3001\u30ad\u30fc\u91cd\u8907\u6642\u306b\u7d99\u7d9a");
        usableProparty.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024 false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

