/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.query;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.plugin.query.AbstractQuery;

public class Query_JDBCUpdate
extends AbstractQuery {
    private static final String VERSION = "4.0.0 (2005/08/31)";

    @Override
    public void execute(String[] stringArray) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.getConnection().prepareCall(this.getStatement());
            callableStatement.setQueryTimeout(DB_MAX_QUERY_TIMEOUT);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    callableStatement.setObject(i + 1, (Object)StringUtil.rTrim((String)stringArray[i]));
                }
            }
            callableStatement.execute();
            this.setErrorCode(0);
        }
        catch (SQLException sQLException) {
            try {
                this.setErrorCode(8);
                String string = sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsSystem.CR + this.getStatement() + HybsSystem.CR;
                this.rollback();
                this.realClose();
                throw new HybsSystemException(string, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Closer.stmtClose(callableStatement);
                throw throwable;
            }
        }
        Closer.stmtClose((Statement)callableStatement);
    }
}

