/**************************************************************************/
/* GE12 ( システムパラメータ定義 )                                        */
/*                                                                        */
/* Created : 2009/08/21 23:39:03                                          */
/**************************************************************************/
CREATE TABLE GE12 (
   SYSTEM_ID   VARCHAR2(10)                   NOT NULL      /* 10  システムID       */
 , PARAM_ID    VARCHAR2(50)                   NOT NULL      /* 20  パラメータID     */
 , SEQNO       NUMBER(7)         DEFAULT 0    NOT NULL      /* 30  表示順           */
 , TITLE       VARCHAR2(300)                                /* 40  タイトル         */
 , PARAM       VARCHAR2(500)                                /* 50  設定値           */
 , CONTENTS    VARCHAR2(4000)                               /* 60  内容             */
 , PARAM_LVL   VARCHAR2(1)       DEFAULT '5'  NOT NULL      /* 70  設定レベル       */
 , KBSAKU      VARCHAR2(1)       DEFAULT '1'  NOT NULL      /* 80  作成区分         */
 , UNIQ        NUMBER(9)         DEFAULT 0    NOT NULL      /* 90  ユニークキー     */
 , FGJ         VARCHAR2(1)       DEFAULT '1'  NOT NULL      /* 100 状態フラグ       */
 , DYSET       VARCHAR2(14)                                 /* 110 登録日時         */
 , DYUPD       VARCHAR2(14)                                 /* 120 更新日時         */
 , USRSET      VARCHAR2(10)                                 /* 130 作成社員         */
 , USRUPD      VARCHAR2(10)                                 /* 140 更新者           */
 , PRGUPD      VARCHAR2(10)                                 /* 150 更新PRG          */
 , FGCRYPT     VARCHAR2(1)       DEFAULT '0'  NOT NULL      /* 160 要再起動フラグ   */
 , CONTXT_PATH VARCHAR2(50)      DEFAULT '**' NOT NULL      /* 170 コンテキストパス */
 , FGREBOOT    VARCHAR2(1)       DEFAULT '0'                /* 180 要再起動フラグ   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 448K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE12S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE12T01 
BEFORE INSERT ON GE12
FOR EACH ROW 
BEGIN 
SELECT GE12S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

