/**************************************************************************/
/* GEA05 ( ロールマスタ )                                                 */
/*                                                                        */
/* Created : 2009/08/21 23:39:03                                          */
/**************************************************************************/
CREATE TABLE GEA05 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ROLE      VARCHAR2(20)                 NOT NULL      /* 20  ロール       */
 , NMROLE    VARCHAR2(200)                              /* 30  ロール名称   */
 , KBROLE    VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 40  ロール区分   */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 50  ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 60  状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 70  登録日時     */
 , DYUPD     VARCHAR2(14)                               /* 80  更新日時     */
 , USRSET    VARCHAR2(10)                               /* 90  作成社員     */
 , USRUPD    VARCHAR2(10)                               /* 100 更新者       */
 , PRGUPD    VARCHAR2(10)                               /* 110 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GEA05S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GEA05T01 
BEFORE INSERT ON GEA05
FOR EACH ROW 
BEGIN 
SELECT GEA05S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

