<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP01"
	title    = "要求テーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->

<!-- forward.jsp から command = "COPY" がセットされて遷移してくるので、複写画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" />

<!-- メッセージ表示を行います。必ずリソースファイルに表示するメッセージを登録し、 -->
<!-- lbl属性を使用して表示させて下さい。 -->
<og:message lbl="MSG0045" comment="複写処理を行います。" /><br />

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="LISTID" must="true" editor="DBMENU" addNoValue="false" >
<jsp:text>
	select LISTID,LISTID
	from GE54
	where FGJ in ('0','1')
	<og:where startKey="and">
		<og:and value = "SYSTEM_ID = '{@SYSTEM_ID}'"	/>
	</og:where>
	group by LISTID,LISTID
	order by 1
</jsp:text>
</og:columnEditor>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />

</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType   = "HTMLTable"
	command        = "{@command}"
	columnWritable = "FGKAN,YKNO,LISTID,JOKEN,GROUPID,OUTDIR,OUTFILE,COMMENTS,SYSTEM_ID,PDF_PASSWD"
	checked        = "{@checked}"
	startNo        = "{@startNo}"
	pageSize       = "{@pageSize}"
/>

<og:hidden name="SQL" >
  <jsp:text>
	insert into GE50
	(
		FGKAN,YKNO,LISTID,JOKEN,GROUPID,OUTDIR,OUTFILE,COMMENTS,SYSTEM_ID,PDF_PASSWD,
		FGJ,DYSET,DYUPD,USRSET,USRUPD,PRGUPD
	)
	values
	(
		[FGKAN],[YKNO],[LISTID],[JOKEN],[GROUPID],[OUTDIR],[OUTFILE],[COMMENTS],[SYSTEM_ID],[PDF_PASSWD],
		'1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}'
	)
  </jsp:text>
</og:hidden>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
