/**************************************************************************/
/* GF05 ( テーブルカラム定義 )                                            */
/*                                                                        */
/* Created : 2009/08/21 23:39:04                                          */
/**************************************************************************/
CREATE TABLE GF05 (
   SYSTEM_ID    VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , TBLSYU       VARCHAR2(1)                   NOT NULL      /* 20  テーブル種別 */
 , TABLE_NAME   VARCHAR2(50)                  NOT NULL      /* 30  テーブル名   */
 , CLM          VARCHAR2(30)                  NOT NULL      /* 40  項目         */
 , SEQNO        NUMBER(7)         DEFAULT 0   NOT NULL      /* 50  表示順       */
 , NAME_JA      VARCHAR2(120)                               /* 60  名称         */
 , CLS_NAME     VARCHAR2(10)                  NOT NULL      /* 70  DBクラス     */
 , USE_LENGTH   VARCHAR2(9)       DEFAULT '0' NOT NULL      /* 80  使用桁数     */
 , DATA_DEFAULT VARCHAR2(30)                                /* 90  初期値       */
 , NOT_NULL     VARCHAR2(1)                                 /* 100 NOT NULL     */
 , FGCOM        VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 110 共通項目F    */
 , UNIQ         NUMBER(9)         DEFAULT 0   NOT NULL      /* 120 ユニークキー */
 , FGJ          VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 130 状態フラグ   */
 , DYSET        VARCHAR2(14)                                /* 140 登録日時     */
 , DYUPD        VARCHAR2(14)                                /* 150 更新日時     */
 , USRSET       VARCHAR2(10)                                /* 160 作成社員     */
 , USRUPD       VARCHAR2(10)                                /* 170 更新者       */
 , PRGUPD       VARCHAR2(10)                                /* 180 更新PRG      */
 , RENDERER     VARCHAR2(10)                                /* 190 表示種別     */
 , EDITOR       VARCHAR2(10)                                /* 200 編集種別     */
 , DBTYPE       VARCHAR2(10)                                /* 210 文字種別     */
 , BIKO         VARCHAR2(2000)                              /* 220 備考         */
 , CDKH         VARCHAR2(1)                                 /* 230 改廃コード   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 5120K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF05S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF05T01 
BEFORE INSERT ON GF05
FOR EACH ROW 
BEGIN 
SELECT GF05S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

