/**************************************************************************/
/* GF21 ( ＴＡＧＬＩＢクラス定義 )                                        */
/*                                                                        */
/* Created : 2009/08/21 23:39:04                                          */
/**************************************************************************/
CREATE TABLE GF21 (
   VERSION     VARCHAR2(10)                 NOT NULL      /* 10  バージョン   */
 , PREFIX      VARCHAR2(10)                 NOT NULL      /* 20  名前空間     */
 , TAGNAME     VARCHAR2(30)                 NOT NULL      /* 30  タグ名称     */
 , SEQ         NUMBER(5)        DEFAULT 0   NOT NULL      /* 40  順           */
 , TAGCLASS    VARCHAR2(100)                NOT NULL      /* 50  TAGクラス名  */
 , TEICLASS    VARCHAR2(100)                              /* 60  TEIクラス名  */
 , BODYCONTENT VARCHAR2(1)                                /* 70  BODY要素     */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 80  ユニークキー */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 90  状態フラグ   */
 , DYSET       VARCHAR2(14)                               /* 100 登録日時     */
 , DYUPD       VARCHAR2(14)                               /* 110 更新日時     */
 , USRSET      VARCHAR2(10)                               /* 120 作成社員     */
 , USRUPD      VARCHAR2(10)                               /* 130 更新者       */
 , PRGUPD      VARCHAR2(10)                               /* 140 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 448K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF21S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF21T01 
BEFORE INSERT ON GF21
FOR EACH ROW 
BEGIN 
SELECT GF21S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

