/**************************************************************************/
/* GF27 ( 逆引きマニュアル )                                              */
/*                                                                        */
/* Created : 2009/08/21 23:39:04                                          */
/**************************************************************************/
CREATE TABLE GF27 (
   SEQ          NUMBER(5)         DEFAULT 0   NOT NULL      /* 10  順           */
 , TITLE        VARCHAR2(300)                 NOT NULL      /* 20  タイトル     */
 , ANSWER       VARCHAR2(200)                               /* 30  回答         */
 , DIFFICULTY   VARCHAR2(1)                                 /* 40  難易度       */
 , PARTNO       NUMBER(2)                                   /* 50  部番号       */
 , PART         VARCHAR2(100)                               /* 60  部           */
 , CHAPTERNO    NUMBER(2)                                   /* 70  章番号       */
 , CHAPTER      VARCHAR2(100)                               /* 80  章           */
 , BIG_CLASS    VARCHAR2(100)                               /* 90  大分類       */
 , INSIDE_CLASS VARCHAR2(100)                               /* 100 中分類       */
 , KEYWORD      VARCHAR2(200)                               /* 110 キーワード   */
 , CONTENTS     CLOB                                        /* 120 内容         */
 , SAMPLE       VARCHAR2(4000)                              /* 130 サンプル     */
 , URL          VARCHAR2(200)                               /* 140 URL          */
 , UNIQ         NUMBER(9)         DEFAULT 0   NOT NULL      /* 150 ユニークキー */
 , FGJ          VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 160 状態フラグ   */
 , DYSET        VARCHAR2(14)                                /* 170 登録日時     */
 , DYUPD        VARCHAR2(14)                                /* 180 更新日時     */
 , USRSET       VARCHAR2(10)                                /* 190 作成社員     */
 , USRUPD       VARCHAR2(10)                                /* 200 更新者       */
 , PRGUPD       VARCHAR2(10)                                /* 210 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF27S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF27T01 
BEFORE INSERT ON GF27
FOR EACH ROW 
BEGIN 
SELECT GF27S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

