<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC01"
	title	= "タグリブ定義"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- 変更はここから -->

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select  a.VERSION,a.SEQ,a.PREFIX || ':' || a.TAGNAME  TAGNAME2 ,
				a.PREFIX,a.TAGNAME,b.HTMLEXT,b.DESCRIPTION,
				a.BODYCONTENT,b.CONTENTS,b.FORM_SAMPLE
		from    GF21 a left outer join GF23 b
		on		a.VERSION     = b.VERSION
		and		a.TAGCLASS    = b.TAGCLASS
		and		a.FGJ         = b.FGJ
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "a.VERSION     LIKE '{@VERSION}%'"      />
		<og:and value = "a.PREFIX      = '{@PREFIX}'"           />
		<og:and value = "a.TAGNAME     LIKE '{@TAGNAME}%'"      />
		<og:and value = "b.DESCRIPTION LIKE '%{@DESCRIPTION}%'" />
		<og:and value = "b.CONTENTS    LIKE '%{@CONTENTS}%'"    />
		<og:and value = "a.FGJ in ( '0','1' )"                  />
		<og:and value = "a.PREFIX || ':' || a.TAGNAME = '{@FULLTAG}'" />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@SORT}" defaultVal="a.VERSION,a.SEQ" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->

<og:viewLink command="{@command}">
	<og:link column="TAGNAME2" gamenId="DOC02" href="index.jsp" target="CONTENTS"
			keys="command,VERSION,PREFIX,TAGNAME,VIEW" vals="NEW,[VERSION],[PREFIX],[TAGNAME],{@VIEW}" />
</og:viewLink>

<og:equals val1="{@VIEW}" nullCheck="true" >
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	noDisplay	 = "CONTENTS,FORM_SAMPLE,PREFIX,TAGNAME"
	writable     = "false"
	pageSize     = "{@pageSize}" />
</og:equals>

<og:equals val1="{@VIEW}" val2="FULL" >
<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLFormatTable"
	command 	 = "{@command}"
	writable     = "false"
	pageSize     = "{@pageSize}"
	rowspan      = "2"
>
<tr>
	<td valign="top">
		[VERSION]<br />[SEQ].[TAGNAME2]<br />[HTMLEXT]<br />[BODYCONTENT]
	</td>
	<td><pre>[CONTENTS]</pre></td>
</tr>
<tr>
	<td colspan="2"><pre>[FORM_SAMPLE]</pre></td>
</tr>
</og:view>
</og:equals>

<!-- ここまで。 -->
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
