<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <SOURCE    ><xsl:value-of select="$ADDRESS"    /></SOURCE>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>


 
 
  <xsl:template match="/">
    <xsl:apply-templates select="//og:column[@name]" mode="name"/>
    <xsl:apply-templates select="//og:select[@name]"  mode="name"/>
    <xsl:apply-templates select="//og:columnEditor[@column]"   mode="column"/>
    <xsl:apply-templates select="//og:columnMarker[@column]"   mode="column" />
    <xsl:apply-templates select="//og:columnCheck[@columns]"   mode="column" />
    <xsl:apply-templates select="//og:link[@columns]"   mode="column" />
    <xsl:apply-templates select="//og:popup[@columns]"   mode="column" />
    <xsl:apply-templates select="//og:columnEditor[@columns]"   mode="columns" />
    <xsl:apply-templates select="//og:columnMarker[@columns]"   mode="columns" />
    <xsl:apply-templates select="//og:input[@name]" mode="name" />
    <xsl:apply-templates select="//og:hidden[@name]"  mode="name" />
    <xsl:apply-templates select="//og:textarea[@name]" mode="name"/>
    <xsl:apply-templates select="//og:button[@name]" mode="name"/>
    <xsl:apply-templates select="//og:directWriteTable[@name]" mode="name"/>
    <xsl:apply-templates select="//og:entryQuery[@names]" mode="names" />
    <xsl:apply-templates select="//og:plsqlUpdate[@names]" mode="names"/>
    <xsl:apply-templates select="//og:tableExist[@names]" mode="names"/>
    <xsl:apply-templates select="//og:tableUpdateParam[@names]" mode="names"/>
    <xsl:apply-templates select="//og:update[@names]" mode="names"/>
    <xsl:apply-templates select="//og:message[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:button[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:backGamen[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:favoriteLink[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:fieldset[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:link[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:option[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:popup[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:requestValue[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:submit[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:tab[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:help[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:input[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:queryButton[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:textArea[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//og:columnEditor[@label]" mode="label"/>
    <xsl:apply-templates select="//og:option[@label]" mode="label"/>
    <xsl:apply-templates select="//og:input[@lbls]" mode="lbls"/>
    <xsl:apply-templates select="//og:orderBy[@lbls]" mode="lbls"/>
    <xsl:apply-templates select="//og:option[@lbls]" mode="lbls"/>
    <xsl:apply-templates select="//text()|//@*" mode="atr"/>
  </xsl:template>
  
  <xsl:template match="*|@*" mode="atr">
    	 <xsl:if test="contains(current(),'{@LBL.')">
     	<xsl:call-template name="atmarklbl">
          <xsl:with-param name="crnt" select="current()"/>
        </xsl:call-template>
   	 </xsl:if>
 	 </xsl:template>
  
  <xsl:template name="atmarklbl">
      <xsl:param name="crnt" select="1"/>
      <xsl:if test="contains($crnt,'{@LBL.')">
        <ROW>
        <xsl:copy-of select="$row_header" />
        <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
        <NAME><xsl:value-of select="substring-before(substring-after($crnt,'{@LBL.'),'}')"       /></NAME>
          <KBRSC		>1</KBRSC>
        </ROW>
        <xsl:call-template name="atmarklbl">
          <xsl:with-param name="crnt" select="substring-after($crnt,'{@LBL.')"/>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>
  
    <xsl:template match="og:*[@lbl]" mode="lbl">
     <xsl:if test="@lbl = translate( @lbl,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
           <NAME        ><xsl:value-of select="@lbl"      /></NAME>
           <KBRSC		>1</KBRSC>
         </ROW>
    </xsl:if>
  </xsl:template>
  
  
  
  <xsl:template name="dvstr">
      <xsl:param name="count" select="1"/>
      <xsl:if test="contains($count,',')">
        <ROW>
        <xsl:copy-of select="$row_header" />
        <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
        <NAME><xsl:value-of select="substring-before($count,',')"       /></NAME>
          <KBRSC		>1</KBRSC>
        </ROW>
        <xsl:call-template name="dvstr">
          <xsl:with-param name="count" select="substring-after($count,',')"/>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>
  
   <xsl:template name="dvstr0">
      <xsl:param name="count" select="1"/>
      <xsl:if test="contains($count,',')">
        <ROW>
        <xsl:copy-of select="$row_header" />
        <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
        <NAME><xsl:value-of select="substring-before($count,',')"       /></NAME>
          <KBRSC		>0</KBRSC>
        </ROW>
        <xsl:call-template name="dvstr">
          <xsl:with-param name="count" select="substring-after($count,',')"/>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>
  
  <xsl:template match="og:*[@lbls]" mode="lbls">
     <xsl:if test="@lbls = translate( @lbls,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
     <xsl:call-template name="dvstr">
          <xsl:with-param name="count" select="concat(@lbls,',')"/>
        </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="og:*[@column]" mode="column">
     <xsl:if test="@lbl = translate( @lbl,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
           <NAME        ><xsl:value-of select="@column"      /></NAME>
           <KBRSC		>1</KBRSC>
         </ROW>
    </xsl:if>
  </xsl:template>
  

  <xsl:template match="og:*[@name]" mode="name">
     <xsl:if test="@name = translate( @name,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
		         <ROW>
		           <xsl:copy-of select="$row_header" />
		           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
		           <NAME        ><xsl:value-of select="@name"      /></NAME>
           <KBRSC		>0</KBRSC>
         </ROW>
         	<xsl:if test="@lbl">
         		<ROW>
         		<xsl:copy-of select="$row_header" />
		           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
		           <NAME        ><xsl:value-of select="@lbl"      /></NAME>
            <KBRSC		>1</KBRSC>
         		</ROW>
         	</xsl:if>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="og:*[@names]" mode="names">
     <xsl:if test="@names = translate( @names,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
     <xsl:call-template name="dvstr0">
          <xsl:with-param name="count" select="concat(@names,',')"/>
        </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="og:*[@columns]" mode="columns">
     <xsl:if test="@columns = translate( @columns,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
     <xsl:call-template name="dvstr0">
          <xsl:with-param name="count" select="concat(@columns,',')"/>
        </xsl:call-template>
    </xsl:if>
  </xsl:template>


</xsl:stylesheet>
