<!-- include ファイルは、jsp:text が使用できません。  -->

<og:message lbl="GFM0001" val0="{@YEAR}" comment=" 年 地区別 売上比率 グラフ" />

<og:chartCreate
	imageMapUrl = "index.jsp?YEAR={@YEAR}&amp;FLAG={@FLAG}&amp;command=NEW,BLOCK"
	imageMapTarget = "CONTENTS"
	width		= "400"
	height		= "200"
>
	<og:chartDataset
		chartType	= "Pie"
	>
		select BLOCK,SUM(SALES) AS SALES
		from GF43
		where YEAR = '{@YEAR}'
		group by BLOCK
		order by SALES DESC
	</og:chartDataset>
</og:chartCreate>

<hr />
<og:message lbl="GFM0002" val0="{@YEAR}" comment=" 年 営業所別 売上順グラフ" />
<og:chartCreate
	imageMapUrl = "index.jsp?YEAR={@YEAR}&amp;FLAG={@FLAG}&amp;command=NEW,BRANCH"
	imageMapTarget = "CONTENTS"
	width		= "800"
	height		= "400"
>
	<og:chartDataset
		chartType	= "Bar"
	>
		select BRANCH,SUM(SALES) AS SALES, SUM(AMOUNT) AS AMOUNT, 
				SUM(SALES-AMOUNT) AS PROFIT
		from GF43
		where YEAR = '{@YEAR}'
		group by BRANCH
		order by SALES DESC
	</og:chartDataset>
</og:chartCreate>

<hr />
<og:message lbl="GFM0003" val0="{@YEAR}" comment=" 年 月別 売上・経費・利益推移グラフ" />
<og:chartCreate
	imageMapUrl = "index.jsp?YEAR={@YEAR}&amp;FLAG={@FLAG}&amp;command=NEW,MONTH"
	imageMapTarget = "CONTENTS"
	width		= "600"
	height		= "400"
>
	<og:chartDataset
		chartType	= "LineAndShape"
	>
		select MONTH,SUM(SALES) AS SALES, SUM(AMOUNT) AS AMOUNT, 
				SUM(SALES-AMOUNT) AS PROFIT
		from GF43
		where YEAR = '{@YEAR}'
		group by MONTH
		order by MONTH
	</og:chartDataset>
</og:chartCreate>
