<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX000"
	title	= "お気に入り編集"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck
	command   = "{@command}"
	nullCheck = "SEQNO,CLASSIFY,NAME_JA"
/>
<og:entry command = "{@command}" />

<og:tableUpdate
	command		= "{@command}"
	queryType	= "JDBCTableUpdate" >
	<jsp:text>{@SQL}</jsp:text>
</og:tableUpdate>

<og:query command = "NEW" debug="true" >
 <jsp:text>
	SELECT SEQNO,NEWSEQNO,UNIQ
	FROM (
	    SELECT 1000 * (dense_rank() OVER (ORDER BY FLOOR(seqno/1000))-1) +
	            10  * (dense_rank() OVER (PARTITION BY FLOOR(seqno/1000)
	            	ORDER BY seqno-floor(seqno/1000)*1000)) AS NEWSEQNO,
	            SEQNO,UNIQ
	     FROM GEA09
	        WHERE   SYSTEM_ID  = '{@MEM.SYSTEM_ID}'
	        AND     USERID     = '{@USER.ID}'
		    AND     SEQNO      !='9999999'
	) XX
	where SEQNO != NEWSEQNO
 </jsp:text>
</og:query>
<og:tableUpdate
	command		= "{@command}"
	selectedAll = "true"
	queryType	= "JDBCTableUpdate" >
 <jsp:text>
	UPDATE GEA09 SET
			SEQNO = [NEWSEQNO]
	WHERE UNIQ = [UNIQ]
 </jsp:text>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
