/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * ガントチャート（テーブル形式）表示クラス用のパラメータ定数定義クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public final static で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.group その他
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class ViewGanttTableParam {

	// 3.5.5.8 (2004/05/20) taglib/ViewGanttParamTag 用のキー
	public final static String GROUP_COLUMNS_KEY   = "h_groupColumns"   ;
	public final static String DURATION_COLUMN_KEY = "h_durationColumn" ;
	public final static String DYSTART_COLUMN_KEY  = "h_dystartColumn"  ;
	public final static String DYSTART_FORMAT_KEY  = "h_dystartFormat"  ;
	public final static String MIN_DURATION_KEY    = "h_minDuration"    ;
	public final static String HEADER_DURATION_KEY = "h_headerDuration" ;
	public final static String HEADER_LOCALE_KEY   = "h_headerLocale"   ;
	public final static String USE_SEQ_DAY_KEY     = "h_useSeqDay"      ;
	public final static String START_DAY_KEY       = "h_startDay"       ;
	public final static String END_DAY_KEY         = "h_endDay"         ;

	// 3.5.5.8 (2004/05/20) taglib/ViewGanttParamTag 用の初期値
	public final static String GROUP_COLUMNS_VALUE   = "PRJCODE,RESOURCE_ID"  ;
	public final static String DYSTART_COLUMN_VALUE  = "DYSTART"  ;
	public final static String DYSTART_FORMAT_VALUE  = "yyyyMMdd" ;
	public final static String MIN_DURATION_VALUE    = "1.0"      ;
	public final static String HEADER_LOCALE_VALUE   = "ja"       ;
	public final static String USE_SEQ_DAY_VALUE     = "false"    ;
}
