/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.report2;

/**
 * 帳票処理のキューの処理方法を定義するインターフェースです。
 *
 * 帳票処理のオブジェクトから、このインターフェースを通じて、キューの生成方法及び終了
 * を操作することで、各振る舞いをこのインターフェースの実装クラスで定義することが可能になります。
 *
 * @og.group 帳票システム
 *
 * @version  4.0
 * @author   Hiroki.Nakamura
 * @since    JDK1.6
 */
public interface QueueManager {

	/**
	 * キューを作成します。
	 * 作成したキューはOOoExecThread#stackQueueによりスタックして下さい。
	 */
	public void create();
	
	/**
	 * キューに帳票データをセットします。
	 * 
	 * @param queue
	 */
	public void set( final ExecQueue queue );
	
	/**
	 * キューを実行中の状態に更新します。
	 * 
	 * @param queue
	 */
	public void execute( final ExecQueue queue );
	
	/**
	 * キューを完了済の状態に更新します。
	 * 
	 * @param queue
	 */
	public void complete( final ExecQueue queue );
	
	/**
	 * キューをエラーの状態に更新します。
	 * 
	 * @param queue
	 */
	public void error( final ExecQueue queue );
}
