/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;

import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.DBTableModel;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

/**
 * ネイティブEXCELファイル(表示種別(RENDERER)適用)の書き出しクラスです。
 * 
 * TableWriter_Excelを継承しており、
 * データ作成部分のみオーバーライドしています。
 * 
 * 出力形式は、openXML形式にも対応しています。
 * 出力ファイルの拡張子が、.xlsならExcel2003のバイナリ形式、.xlsxならExcel2007の
 * openXML形式で出力されます。
 *
 * @og.group ファイル出力
 *
 * @og.rev 4.3.4.3 (2008/12/22) 追加
 * @og.rev 4.3.6.7 (2009/05/22) ooxml形式対応
 * 
 * @version  4.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public class TableWriter_ExcelRenderer extends TableWriter_Excel {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	// 4.3.4.4 (2009/01/01)
//	/**
//	 * デフォルトコンストラクター
//	 *
//	 */
//	public TableWriter_ExcelRenderer() {
//		super();
//	}

	
	/**
	 * PrintWriter に DBTableModelのテーブル情報を書き込みます。
	 * このクラスでは，データを ダブルコーテーション（"）で囲みます。
	 * PrintWriter に DBTableModelのテーブル情報を書き込みます。
	 *
	 * @param	table DBTableModel
	 * @param	writer PrintWriter
	 */
	protected void writeData( final DBTableModel table,final PrintWriter writer ) {
		int numberOfRows =	table.getRowCount();

		short nColIndex;
//		HSSFRow  oRow;
		Row  oRow;

		boolean[] nvar = new boolean[numberOfColumns];
		int[] cellType = new int[numberOfColumns];
		for( int clm=0; clm<numberOfColumns; clm++ ) {
			NativeType nativeType = dbColumn[clm].getNativeType();
			switch( nativeType ) {
				case INT    :
				case LONG   :
				case DOUBLE :
//					cellType[clm] = HSSFCell.CELL_TYPE_NUMERIC ;
					cellType[clm] = Cell.CELL_TYPE_NUMERIC ;
						break;
				case STRING :
				case CALENDAR :
				default :
//						cellType[clm] = HSSFCell.CELL_TYPE_STRING ;
						cellType[clm] = Cell.CELL_TYPE_STRING ;
						break;
			}
			nvar[clm] = "NVAR".equals( dbColumn[clm].getDbType()) ;
		}

		for( int row=0; row<numberOfRows; row++ ) {
			nColIndex = 0;
			oRow = setFirstCellValue( nRowIndex++, nColIndex++, String.valueOf( row+1 ) );
			for( int i=0; i<numberOfColumns; i++ ) {
				int clm = clmNo[i];
				String val = table.getValue(row,clm);
				 if( nvar[clm] ) {
				 	val = StringUtil.getReplaceEscape( val );
				 }
				else {
					val = StringUtil.spanCut( dbColumn[clm].getRendererValue( val ) );
				}

				setRowCellValue( oRow, nColIndex++, val,cellType[clm] );
			}

			// 余計なセルを削除
			removeRowCell( oRow, nColIndex );
		}
	}
}
