/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.view.PrintJobEvent;
import com.sun.star.view.PrintableState;
import com.sun.star.view.XPrintJobBroadcaster;
import com.sun.star.view.XPrintJobListener;
import com.sun.star.view.XPrintable;
import java.io.File;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report2.SOfficeProcess;

public class OdsConverter {
    private OdsConverter() {
    }

    public static final XComponent open(XDesktop xDesktop, String string) {
        XComponent xComponent;
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Hidden";
        propertyValueArray[0].Value = true;
        String string2 = "file:///" + string.replace('\\', '/');
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop);
        try {
            xComponent = xComponentLoader.loadComponentFromURL(string2, "_default", 0, propertyValueArray);
        }
        catch (IOException iOException) {
            throw new HybsSystemException("Calc\u7acb\u3061\u4e0a\u3052\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(\u5165\u51fa\u529b\u30a8\u30e9\u30fc)\u3002", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u4e0d\u6b63)\u3002", illegalArgumentException);
        }
        return xComponent;
    }

    public static final void close(XComponent xComponent) {
        XCloseable xCloseable = null;
        int n = 0;
        while (true) {
            try {
                xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xComponent);
                xCloseable.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                if (n == 600) {
                    throw new HybsSystemException("soffice\u30d7\u30ed\u30bb\u30b9\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002", closeVetoException);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    throw new HybsSystemException(interruptedException);
                }
                ++n;
                continue;
            }
            break;
        }
    }

    public static final void print(XComponent xComponent, String string) {
        if (string == null || string.length() == 0) {
            throw new HybsSystemException("\u30d7\u30ea\u30f3\u30bf\u30fc\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)xComponent);
        XPrintJobBroadcaster xPrintJobBroadcaster = (XPrintJobBroadcaster)UnoRuntime.queryInterface(XPrintJobBroadcaster.class, (Object)xPrintable);
        MyPrintJobListener myPrintJobListener = new MyPrintJobListener();
        xPrintJobBroadcaster.addPrintJobListener((XPrintJobListener)myPrintJobListener);
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Name";
        propertyValueArray[0].Value = "Linux".equals(HybsSystem.sys("OS_INFO")) ? "<" + string + ">" : string;
        try {
            xPrintable.setPrinter(propertyValueArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", illegalArgumentException);
        }
        String string2 = null;
        PropertyValue[] propertyValueArray2 = xPrintable.getPrinter();
        for (int i = 0; i < propertyValueArray2.length; ++i) {
            if (!"Name".equals(propertyValueArray2[i].Name)) continue;
            string2 = (String)propertyValueArray2[i].Value;
            break;
        }
        if (!string.equalsIgnoreCase(string2)) {
            String string3 = "\u30d7\u30ea\u30f3\u30bf\u30fc[" + string + "]\u3092\u767a\u884c\u5148\u306b\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + "\u5b58\u5728\u3057\u306a\u3044\u30d7\u30ea\u30f3\u30bf\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002";
            throw new HybsSystemException(string3);
        }
        PropertyValue[] propertyValueArray3 = new PropertyValue[]{new PropertyValue()};
        propertyValueArray3[0].Name = "Wait";
        propertyValueArray3[0].Value = true;
        try {
            xPrintable.print(propertyValueArray3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", illegalArgumentException);
        }
        if (myPrintJobListener.getStatus() == null || myPrintJobListener.getStatus() != PrintableState.JOB_COMPLETED && myPrintJobListener.getStatus() != PrintableState.JOB_SPOOLED) {
            throw new HybsSystemException("Error Occured while spooling print job. Check Spooler-Service!!!");
        }
    }

    public static final void pdf(XComponent xComponent, String string, String string2) {
        Object object;
        PropertyValue[] propertyValueArray;
        if (string2 == null || string2.length() == 0) {
            propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = "calc_pdf_Export";
        } else {
            object = new PropertyValue[2];
            object[0] = new PropertyValue();
            object[0].Name = "EncryptFile";
            object[0].Value = true;
            object[1] = new PropertyValue();
            object[1].Name = "DocumentOpenPassword";
            object[1].Value = string2;
            propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = "calc_pdf_Export";
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "FilterData";
            propertyValueArray[1].Value = object;
        }
        object = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        try {
            xStorable.storeToURL((String)object, propertyValueArray);
        }
        catch (IOException iOException) {
            throw new HybsSystemException("PDF\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", iOException);
        }
    }

    public static final void excel(XComponent xComponent, String string) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "FilterName";
        propertyValueArray[0].Value = "MS Excel 97";
        String string2 = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        try {
            xStorable.storeAsURL(string2, propertyValueArray);
        }
        catch (IOException iOException) {
            throw new HybsSystemException("Excel\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", iOException);
        }
    }

    public static final void ods(XComponent xComponent, String string) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "FilterName";
        propertyValueArray[0].Value = "calc8";
        String string2 = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        try {
            xStorable.storeAsURL(string2, propertyValueArray);
        }
        catch (IOException iOException) {
            throw new HybsSystemException("ODS\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void convert(String string, String string2) {
        SOfficeProcess sOfficeProcess = null;
        try {
            sOfficeProcess = new SOfficeProcess("conv");
            sOfficeProcess.bootstrap();
            XDesktop xDesktop = sOfficeProcess.getDesktop();
            XComponent xComponent = OdsConverter.open(xDesktop, string);
            OdsConverter.ods(xComponent, string2);
            System.out.println("Converting " + string + " to " + string2);
            OdsConverter.close(xComponent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sOfficeProcess.close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("usage : OdsConverter [input] [outputdir]");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (file2.mkdirs()) {
            System.err.println(stringArray[1] + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getAbsolutePath().endsWith(".xls")) continue;
                String string = fileArray[i].getAbsolutePath();
                String string2 = file2.getAbsolutePath() + File.separator + fileArray[i].getName().replace(".xls", ".ods");
                OdsConverter.convert(string, string2);
            }
        } else if (file.getAbsolutePath().endsWith(".xls")) {
            String string = file.getAbsolutePath();
            String string3 = file2.getAbsolutePath() + File.separator + file.getName().replace(".xls", ".ods");
            OdsConverter.convert(string, string3);
        }
    }

    private static class MyPrintJobListener
    implements XPrintJobListener {
        private PrintableState status = null;

        private MyPrintJobListener() {
        }

        public void printJobEvent(PrintJobEvent printJobEvent) {
            this.status = printJobEvent.State;
        }

        public void disposing(EventObject eventObject) {
        }

        public PrintableState getStatus() {
            return this.status;
        }
    }
}

