/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.xml.HybsXMLHandler;
import org.opengion.fukurou.xml.TagElement;
import org.opengion.fukurou.xml.TagElementListener;

public class HybsXMLSave
implements TagElementListener {
    private static final String CR = System.getProperty("line.separator");
    private String tableName = null;
    private String[] keyColumns = null;
    private Connection connection = null;
    private PreparedStatement insPstmt = null;
    private PreparedStatement updPstmt = null;
    private ParameterMetaData insMeta = null;
    private ParameterMetaData updMeta = null;
    private int insCnt = 0;
    private int updCnt = 0;
    private int delCnt = 0;
    private Map<String, String> defaultMap = null;
    private Map<String, String> afterMap = null;
    private List<String> updClms = null;
    private String[] insClms = null;
    private final boolean useParamMetaData;
    private static final Pattern pattern = Pattern.compile("\\[\\w*\\]");

    public HybsXMLSave(Connection connection) {
        this(connection, null);
    }

    public HybsXMLSave(Connection connection, String string) {
        this.connection = connection;
        this.tableName = string;
        this.useParamMetaData = ApplicationInfo.useParameterMetaData(connection);
    }

    @Override
    public void actionInit(TagElement tagElement) {
        String string = tagElement.get("tableName");
        if (string != null) {
            this.tableName = string;
        }
    }

    @Override
    public void actionRow(TagElement tagElement) {
        tagElement.setAfterMap(this.afterMap);
        try {
            int n;
            int n2;
            Object object;
            int n3 = 0;
            if (this.updPstmt != null) {
                object = tagElement.getValues(this.updClms);
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    if (object[n2] != null && object[n2].length() == 0) {
                        object[n2] = null;
                    }
                    if (this.useParamMetaData) {
                        n = this.updMeta.getParameterType(n2 + 1);
                        this.updPstmt.setObject(n2 + 1, (Object)object[n2], n);
                        continue;
                    }
                    this.updPstmt.setObject(n2 + 1, object[n2]);
                }
                n3 = this.updPstmt.executeUpdate();
                if (n3 > 1) {
                    String string = "Update \u30ad\u30fc\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + CR + tagElement.toString() + CR;
                    throw new RuntimeException(string);
                }
                this.updCnt += n3;
            }
            if (n3 == 0) {
                if (this.insPstmt == null) {
                    this.insClms = tagElement.getKeys();
                    object = this.insertSQL(this.insClms, this.tableName);
                    this.insPstmt = this.connection.prepareStatement((String)object);
                    if (this.useParamMetaData) {
                        this.insMeta = this.insPstmt.getParameterMetaData();
                    }
                }
                object = tagElement.getValues(this.insClms);
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    if (object[n2] != null && object[n2].length() == 0) {
                        object[n2] = null;
                    }
                    if (this.useParamMetaData) {
                        n = this.insMeta.getParameterType(n2 + 1);
                        this.insPstmt.setObject(n2 + 1, (Object)object[n2], n);
                        continue;
                    }
                    this.insPstmt.setObject(n2 + 1, object[n2]);
                }
                this.insCnt += this.insPstmt.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            String string = "DB\u767b\u9332\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + CR + tagElement.toString() + CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + CR;
            throw new RuntimeException(string, sQLException);
        }
    }

    @Override
    public void actionExecSQL(TagElement tagElement) {
        Statement statement = null;
        try {
            String string = tagElement.getBody();
            statement = this.connection.createStatement();
            this.delCnt += statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            try {
                String string = "DB\u767b\u9332\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + CR + tagElement.toString() + CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + CR;
                throw new RuntimeException(string, sQLException);
            }
            catch (Throwable throwable) {
                Closer.stmtClose(statement);
                throw throwable;
            }
        }
        Closer.stmtClose(statement);
    }

    @Override
    public void actionMergeSQL(TagElement tagElement) {
        if (this.updPstmt != null) {
            String string = "MERGE_SQL\u30bf\u30b0\u304c\u3001\u8907\u6570\u56de\u8a18\u8ff0\u3055\u308c\u3066\u3044\u307e\u3059\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + CR + tagElement.toString() + CR;
            throw new RuntimeException(string);
        }
        String string = tagElement.getBody();
        Matcher matcher = pattern.matcher(string);
        this.updClms = new ArrayList<String>();
        while (matcher.find()) {
            this.updClms.add(string.substring(matcher.start() + 1, matcher.end() - 1));
        }
        String string2 = matcher.replaceAll("?");
        try {
            this.updPstmt = this.connection.prepareStatement(string2);
            if (this.useParamMetaData) {
                this.updMeta = this.updPstmt.getParameterMetaData();
            }
        }
        catch (SQLException sQLException) {
            String string3 = "Statement\u4f5c\u6210\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + CR + tagElement.toString() + CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + CR;
            throw new RuntimeException(string3, sQLException);
        }
    }

    public void setKeyColumns(String[] stringArray) {
        this.keyColumns = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.keyColumns, 0, this.keyColumns.length);
    }

    public void setDefaultMap(Map<String, String> map) {
        this.defaultMap = map;
    }

    public void setAfterMap(Map<String, String> map) {
        this.afterMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertXML(Reader reader) {
        try {
            HybsXMLHandler hybsXMLHandler = new HybsXMLHandler();
            hybsXMLHandler.setTagElementListener(this);
            hybsXMLHandler.setDefaultMap(this.defaultMap);
            hybsXMLHandler.parse(reader);
        }
        finally {
            Closer.stmtClose(this.insPstmt);
            Closer.stmtClose(this.updPstmt);
            this.insPstmt = null;
            this.updPstmt = null;
        }
    }

    private String insertSQL(String[] stringArray, String string) {
        int n;
        if (string == null) {
            String string2 = "tableName \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + "tableName \u306f\u3001\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3067\u6307\u5b9a\u3059\u308b\u304b\u3001ROWSET\u306etableName\u5c5e\u6027\u3067" + "\u6307\u5b9a\u3057\u3066\u304a\u304f\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059" + CR;
            throw new RuntimeException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("insert into ").append(string);
        stringBuilder.append(" ( ");
        stringBuilder.append(stringArray[0]);
        for (n = 1; n < stringArray.length; ++n) {
            stringBuilder.append(",").append(stringArray[n]);
        }
        stringBuilder.append(" ) values ( ");
        stringBuilder.append("?");
        for (n = 1; n < stringArray.length; ++n) {
            stringBuilder.append(",").append("?");
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    public int getInsertCount() {
        return this.insCnt;
    }

    public int getUpdateCount() {
        return this.updCnt;
    }

    public int getDeleteCount() {
        return this.delCnt;
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws ClassNotFoundException, SQLException {
        int n;
        int n2;
        int n3;
        if (stringArray.length < 5) {
            LogWriter.log("Usage: java org.opengion.fukurou.xml.HybsXMLSave USER PASSWD URL TABLE FILE [ENCODE] [DRIVER]");
            LogWriter.log("   USER  : DB\u63a5\u7d9a\u30e6\u30fc\u30b6\u30fc\uff08GE)");
            LogWriter.log("   PASSWD: DB\u63a5\u7d9a\u30d1\u30b9\u30ef\u30fc\u30c9(GE)");
            LogWriter.log("   URL   : DB\u63a5\u7d9aJDBC\u30c9\u30e9\u30a4\u30d0URL(jdbc:oracle:thin:@localhost:1521:HYBS)");
            LogWriter.log("   TABLE : \u767b\u9332\u3059\u308b\u30c6\u30fc\u30d6\u30ebID(GE21)");
            LogWriter.log("   FILE  : \u767b\u9332\u3059\u308bORACLE XDK \u5f62\u5f0f XML\u30d5\u30a1\u30a4\u30eb(GE21.xml)");
            LogWriter.log(" [ ENCODE: \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9 \u521d\u671f\u5024:UTF-8 ]");
            LogWriter.log(" [ DRIVER: JDBC\u30c9\u30e9\u30a4\u30d0\u30fc \u521d\u671f\u5024:oracle.jdbc.OracleDriver ]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray.length == 6 ? stringArray[5] : "UTF-8";
        String string7 = stringArray.length == 7 ? stringArray[6] : "oracle.jdbc.OracleDriver";
        Class.forName(string7);
        Connection connection = DriverManager.getConnection(string3, string, string2);
        BufferedReader bufferedReader = null;
        try {
            connection.setAutoCommit(false);
            HybsXMLSave hybsXMLSave = new HybsXMLSave(connection, string4);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string5), string6));
            hybsXMLSave.insertXML(bufferedReader);
            n3 = hybsXMLSave.getInsertCount();
            n2 = hybsXMLSave.getUpdateCount();
            n = hybsXMLSave.getDeleteCount();
            Closer.commit(connection);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string8 = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + fileNotFoundException.getMessage() + CR + "Table=[" + string4 + "] File =[" + string5 + "]";
                throw new RuntimeException(string8, fileNotFoundException);
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string9 = "\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + unsupportedEncodingException.getMessage() + CR + "Table=[" + string4 + "] Encode =[" + string6 + "]";
                    throw new RuntimeException(string9, unsupportedEncodingException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedReader);
                Closer.connClose(connection);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedReader);
        Closer.connClose(connection);
        System.out.println("XML File[" + string5 + "] Into [" + string4 + "] Table");
        System.out.println("   Delete Count : [" + n + "]");
        System.out.println("   Insert Count : [" + n3 + "]");
        System.out.println("   Update Count : [" + n2 + "]");
    }
}

