/**************************************************************************/
/* GE33 ( グループマスタ )                                                */
/*                                                                        */
/* Created : 2009/10/02 11:56:26                                          */
/**************************************************************************/
CREATE TABLE GE33 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID              */
 , GROUP_ID  VARCHAR2(20)                 NOT NULL      /* 20  グループID              */
 , MEMBER    VARCHAR2(200)                NOT NULL      /* 30  メンバー（ID/アドレス） */
 , NAME      VARCHAR2(200)                              /* 40  名称                    */
 , NM_KBN    VARCHAR2(1)                  NOT NULL      /* 50  名称区分                */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 60  ユニークキー            */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 70  状態フラグ              */
 , DYSET     VARCHAR2(14)                               /* 80  登録日時                */
 , DYUPD     VARCHAR2(14)                               /* 90  更新日時                */
 , USRSET    VARCHAR2(10)                               /* 100 作成社員                */
 , USRUPD    VARCHAR2(10)                               /* 110 更新者                  */
 , PRGUPD    VARCHAR2(10)                               /* 120 更新PRG                 */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE33S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE33T01 
BEFORE INSERT ON GE33
FOR EACH ROW 
BEGIN 
SELECT GE33S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

