<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0001"
	title    = "ユーザー定義"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,NAME,ROLES"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select '1' as WRITABLE,USERID,PASSWD,LANG,NAME,ROLES,DROLES,COMMENTS,DYVALID,DYPASSWD,SYSTEM_ID,FGJ,UNIQ,FGDEFAULT
		from GEA10
	</jsp:text>
	<og:where>
		<og:and value = "FGJ		=	'{@FGJ}'"		/>
		<og:and value = "SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "USERID	like '{@USERID}%'"	/>
		<og:and value = "NAME		like '{@NAME}%'"	/>
		<og:and value = "LANG		=	'{@LANG}'"		/>
		<og:and value = "ROLES		like '{@ROLES}%'"	/>
		<og:and value = "DROLES	like '{@DROLES}%'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,USERID,FGDEFAULT" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,USERID,PASSWD,ROLES" must="true" />

<og:viewMarker isRenderer="false"  command="NEW">
	<og:columnMarker column="ROLES" onMark="true">
	[ROLES]<img style="cursor:pointer;" src="{@SYS.JSP}/image/multiChoose.gif"
				onClick="ogOpen('{@SYS.JSP}/custom/multiChoose.jsp?name=ROLES&amp;SYSTEM_ID={@SYSTEM_ID}&amp;editor=DBMENU&amp;param=select ROLE,NMROLE from GEA05 where SYSTEM_ID=\\'{@SYSTEM_ID}\\' and KBROLE=\\'1\\' and FGJ=\\'1\\'', event,'ROLES__[I]','width=500,height=200,resizable=no' );" />
	</og:columnMarker>
	<og:columnMarker column="DROLES" onMark="true">
	[DROLES]<img style="cursor:pointer;" src="{@SYS.JSP}/image/multiChoose.gif"
				onClick="ogOpen('{@SYS.JSP}/custom/multiChoose.jsp?name=DROLES&amp;SYSTEM_ID={@SYSTEM_ID}&amp;editor=DBMENU&amp;param=select ROLE,NMROLE from GEA05 where SYSTEM_ID=\\'{@SYSTEM_ID}\\' and KBROLE=\\'2\\' and FGJ=\\'1\\'', event,'DROLES__[I]','width=500,height=200,resizable=no' );" />
	</og:columnMarker>
</og:viewMarker>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals="DYPASSWD" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"SYSTEM_ID,USERID,PASSWD,DYPASSWD"' />
	<og:submit  value="update"   lbl="PASSWD"    command="MODIFY" accesskey="P"
		keys="columnWritable,passwd" vals="PASSWD,true" />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable,logicalDelete" vals="null,true" />
	<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
		keys="columnWritable" vals="null" />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GEA10" /></strong></legend>
		<og:column  name="SYSTEM_ID" useRequestValue="false" must="true" td="no" />
		<og:submit  value="update" lbl="COPY" command="COPY"
			keys="noWritable,sysins" vals="DYPASSWD,true" />
	</fieldset>
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
