<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP10"
	title    = "帳票再発行"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "YKNO,LISTID,FGKAN"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select  a.SYSTEM_ID,a.FGKAN,a.YKNO,a.LISTID,b.LISTNAME,a.JOKEN,
				a.DMN_NAME,a.DMN_HOST,
				a.DYSET,a.DYUPD,a.USRSET,a.USRUPD,a.PRGUPD
		from    GE50 a left outer join GE54 b
		on		a.SYSTEM_ID = b.SYSTEM_ID
		and		a.LISTID    = b.LISTID
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "a.SYSTEM_ID = '{@SYS.SYSTEM_ID}'" />
		<og:and value = "a.YKNO      =    '{@YKNO}'"       />
		<og:and value = "a.LISTID    LIKE '{@LISTID}%'"    />
		<og:and value = "a.FGKAN     =    '{@FGKAN}'"      />
		<og:and value = "a.FGJ       in   ( '0','1' )"     />
		<og:and value = "a.DYSET    &gt;= '{@DYSETFROM}'"  />
		<og:and value = "a.DYSET    &lt;= '{@DYSETTO}99'"  />
	</og:where>
	<jsp:text>
		order by a.SYSTEM_ID,a.YKNO DESC
	</jsp:text>
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="JOKEN" must="true" editor="DBMENU" addNoValue="false" >
<jsp:text>
	select	JOKEN,JOKEN
	from	GE53
	where	SYSTEM_ID = '{@SYS.SYSTEM_ID}'
	and		FGJ  IN ('0','1')
	group by JOKEN
	order by 1
</jsp:text>
</og:columnEditor>
<og:columnEditor column="FGKAN" must="true" />

<og:viewLink command="{@command}">
	<og:link column="FGKAN" gamenId="REP07" href="index.jsp" target="CONTENTS"
			onLink="[FGKAN]" markList="7,8"
			keys="command,SYSTEM_ID,YKNO" vals="NEW,[SYSTEM_ID],[YKNO]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	noDisplay    = "SYSTEM_ID"
	checked      = "{@checked}"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
/>

</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
