/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;

public class FileLineModel
extends LineModel {
    private static final String[] KEYS = new String[]{"Level", "File", "Length", "Modify", "LineCnt", "Biko"};
    private static final int LEVEL = 0;
    private static final int FILE = 1;
    private static final int LENGTH = 2;
    private static final int MODIFY = 3;
    private static final int LINECNT = 4;
    private static final int BIKO = 5;
    private final DateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPAN);
    private final boolean useLineCnt;

    public FileLineModel() {
        this(false);
    }

    public FileLineModel(boolean bl) {
        this.useLineCnt = bl;
        this.init(KEYS);
    }

    public FileLineModel(LineModel lineModel) {
        this.init(lineModel.getNames());
        Object[] objectArray = lineModel.getValues();
        this.setValue(0, Integer.valueOf((String)objectArray[0]));
        this.setValue(1, new File((String)objectArray[1]));
        this.setValue(2, Long.valueOf((String)objectArray[2]));
        this.setValue(3, (String)objectArray[3]);
        String string = (String)objectArray[4];
        boolean bl = this.useLineCnt = string != null && string.length() > 0 && !"null".equals(string);
        if (this.useLineCnt) {
            this.setValue(4, string);
        }
        this.setValue(5, (String)objectArray[5]);
    }

    public void setFileVals(int n, File file) {
        this.setValue(0, n);
        this.setValue(1, file);
        this.setValue(2, file.length());
        this.setValue(3, this.formatter.format(new Date(file.lastModified())));
        if (this.useLineCnt) {
            this.setValue(4, this.getLineCnt(file));
        }
    }

    public void setFile(File file) {
        this.setValue(1, file);
    }

    public void setBiko(String string) {
        this.setValue(5, string);
    }

    public int getLebel() {
        return (Integer)this.getValue(0);
    }

    public File getFile() {
        return (File)this.getValue(1);
    }

    public long getLength() {
        return (Long)this.getValue(2);
    }

    public String getModify() {
        return (String)this.getValue(3);
    }

    private String getLineCnt(File file) {
        int n = 0;
        BufferedReader bufferedReader = FileUtil.getBufferedReader(file, "JISAutoDetect");
        try {
            if (!file.isDirectory()) {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u30ab\u30a6\u30f3\u30c8\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + file + "]";
            throw new RuntimeException(string, iOException);
        }
        finally {
            Closer.ioClose(bufferedReader);
        }
        return String.valueOf(n);
    }
}

