/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelImpl;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public final class DBTableModelUtil {
    private DBTableModelUtil() {
    }

    public static DBTableModel makeDBTable(String string, String[] stringArray, ResourceManager resourceManager, ApplicationInfo applicationInfo) {
        return DBTableModelUtil.makeDBTable(string, stringArray, resourceManager, applicationInfo, null);
    }

    public static DBTableModel makeDBTable(String string, String[] stringArray, ResourceManager resourceManager, ApplicationInfo applicationInfo, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        DBTableModel dBTableModel = null;
        Query query = QueryFactory.newInstance("JDBCPrepared");
        ErrorMessage errorMessage = null;
        try {
            query.setConnectionID(string2);
            query.setResourceManager(resourceManager);
            query.setStatement(string);
            query.execute(stringArray);
            int n = query.getErrorCode();
            int n2 = query.getExecuteCount();
            if (n < 2 && n2 >= 0) {
                dBTableModel = query.getDBTableModel();
                if (query.isUpdate()) {
                    query.commit();
                }
            } else {
                errorMessage = query.getErrorMessage();
            }
        }
        catch (HybsSystemException hybsSystemException) {
            if (query != null) {
                query.rollback();
            }
            throw hybsSystemException;
        }
        finally {
            if (query != null) {
                query.close();
            }
            QueryFactory.close(query);
        }
        if (errorMessage != null) {
            throw new HybsSystemException(errorMessage.toString());
        }
        return dBTableModel;
    }

    public static DBTableModel newDBTable() {
        return new DBTableModelImpl();
    }

    public static DBTableModel makeDBTable(String[] stringArray, String[][] stringArray2, ResourceManager resourceManager) {
        int n;
        if (stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0 || stringArray2[0] == null || stringArray2[0].length == 0) {
            return null;
        }
        if (stringArray.length != stringArray2[0].length) {
            throw new HybsSystemException("\u30ad\u30fc\u306e\u30ab\u30e9\u30e0\u6570\u3068\u30c7\u30fc\u30bf\u306e\u30ab\u30e9\u30e0\u6570\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        int n2 = stringArray.length;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n2);
        DBColumn[] dBColumnArray = new DBColumn[n2];
        for (n = 0; n < n2; ++n) {
            dBColumnArray[n] = resourceManager.makeDBColumn(stringArray[n]);
            dBTableModel.setDBColumn(n, dBColumnArray[n]);
        }
        n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            dBTableModel.addColumnValues(stringArray2[i]);
        }
        return dBTableModel;
    }
}

