<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0004"
	title    = "コード"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,CLM,CODE"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select
		'1' as WRITABLE,A.CLM,'' NAME_JA,'' LNAME,'' SNAME,A.CODE,A.SEQNO,
		A.CODELVL,A.CODEGRP,A.CODE_PARAM,A.KBSAKU,A.COMMENTS,'' DESCRIPTION,A.SYSTEM_ID,
		A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,A.UNIQ,'ja' LANG,'0' EXIST_GEA08,0 UNIQ_GEA08,A.CLM CLM_T
		from GEA04 A
		where A.SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.FGJ           =    '{@FGJ}'"            />
		<og:and value = "UPPER(A.CLM)    like UPPER('{@CLM}%')"    />
		<og:and value = "UPPER(A.CODE)   like UPPER('{@CODE}%')"   />
		<og:and value = "A.KBSAKU        =    '{@KBSAKU}'"         />
		<og:and value = "A.CODEGRP       like '{@CODEGRP}%'"       />
		<og:and value = "A.RDC_CODE      =    '{@RDC_CODE}'"       />
		<og:and value = "A.DYUPD  &gt;   =    '{@DYUPDFROM}'"      />
		<og:and value = "A.DYUPD  &lt;   =    '{@DYUPDTO}99'"      />
		<og:and value = "A.RELEASE_NOTES like '{@RELEASE_NOTES}%'" />
		<og:and value = "A.USRUPD        =    '{@USRUPD}'"         />
		<og:and value = "A.CDKH {@CDKH}" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.CLM,A.SEQNO,A.SYSTEM_ID DESC,A.KBSAKU DESC" />
</og:query>

<og:tableMerge
	action        = "GROUP"
	masterKeys    = "CLM,CODE"
	display       = "false"
/>

<og:value command="SET" key="NAME_SQL">
	select A.NAME_JA
	from GEA03 A
	where A.SYSTEM_ID in ( '{@SYSTEM_ID}','**' )
	and A.CLM = [CLM]
	<og:where startKey="and">
		<og:and value = "A.NAME_JA      like '{@NAME_JA}%'"      />
		<og:and value = "A.FGJ          =    '{@FGJ}'"          />
	</og:where>
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC
</og:value>

<og:value command="SET" key="LABEL_SQL">
	select A.LNAME, A.SNAME, A.DESCRIPTION, A.LANG
	from GEA08 A
	where A.SYSTEM_ID in ( '{@SYSTEM_ID}','**' )
	and A.CLM = [CLM]{@DBF.CON}'.'{@DBF.CON}[CODE]
	<og:where startKey="and">
		<og:and value = "A.LNAME        like '{@LNAME}%'"       />
		<og:and value = "A.SNAME        like '{@SNAME}%'"       />
		<og:and value = "A.LANG         =    '{@LANG}'"         />
		<og:and value = "A.FGJ          =    '{@FGJ}'"          />
	</og:where>
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC
</og:value>

<og:equals val1="{@NAME_JA}" nullCheck="true" notEquals="true">
	<og:value command="SET" key="INNER_JOIN_GEA03" value="true" />
</og:equals>
<og:tableFilter classId="DBSELECT" dbid="{@FROM_DBID}" selectedAll="true" keys="INNER_JOIN" vals="{@INNER_JOIN_GEA03}">
	{@NAME_SQL}
</og:tableFilter>

<og:equals val1="{@LNAME}{@SNAME}" nullCheck="true" notEquals="true">
	<og:value command="SET" key="INNER_JOIN_GEA08" value="true" />
</og:equals>
<og:tableFilter classId="DBSELECT" dbid="{@FROM_DBID}" selectedAll="true" keys="INNER_JOIN" vals="{@INNER_JOIN_GEA08}" >
	{@LABEL_SQL}
</og:tableFilter>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GE0003" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="1"
		keys="command,SYSTEM_ID,CLM,FGJ"
		vals="NEW,[SYSTEM_ID],[CLM],1" />
	<og:link column="LNAME" gamenId="GE0005" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="1"
		keys="command,SYSTEM_ID,CLM,FGJ"
		vals="NEW,[SYSTEM_ID],[CLM],1" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals="NAME_JA" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"SYSTEM_ID,CLM,CODE,NAME_JA,KBSAKU,RDC_CODE,CDKH"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable,logicalDelete" vals="null,true" />
	<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
		keys="columnWritable" vals="null" />
	<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA04" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  value="update" lbl="COPY" command="COPY"
				keys="noWritable,sysins" vals="NAME_JA,true" />
		</fieldset>
	</og:equals>
	<br />
</og:writeCheck>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
		<jsp:text>{@USER.LASTSQL}</jsp:text>
	</og:query>
	<og:tableFilter classId="DBSELECT" scope="request" dbid="{@TO_DBID}" selectedAll="true" keys="INNER_JOIN" vals="{@INNER_JOIN_GEA03}">
		{@NAME_SQL}
	</og:tableFilter>
	<og:tableFilter classId="DBSELECT" scope="request" dbid="{@TO_DBID}" selectedAll="true" keys="INNER_JOIN" vals="{@INNER_JOIN_GEA08}">
		{@LABEL_SQL}
	</og:tableFilter>

	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM,CODE,KBSAKU"
		diffKeys      = "SEQNO,CODELVL,CODEGRP,CODE_PARAM"
		slaveScope    = "request"
		modifyClms    = "UNIQ,UNIQ_GEA08"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,EXIST_GEA08,UNIQ_GEA08,CLM_T"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
