/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opengion.fukurou.taglet.DocletTagWriter;
import org.opengion.fukurou.taglet.DocletUtil;
import org.opengion.fukurou.util.LogWriter;

public final class DocletSpecific {
    private static final String SELECT_PACKAGE = "org.opengion";
    private static final boolean NOT_PRIVATE = false;
    private static final String ENCODE = "UTF-8";
    private static final String OG_FOR_SMPL = "og.formSample";
    private static final String OG_REV = "og.rev";
    private static final String OG_GROUP = "og.group";
    private static final String DOC_VERSION = "version";
    private static final String DOC_AUTHOR = "author";
    private static final String DOC_SINCE = "since";
    private static final String CONSTRUCTOR = "\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf";
    private static final String METHOD = "\u30e1\u30bd\u30c3\u30c9";
    private static final Set<String> methodSet = new HashSet<String>();

    private DocletSpecific() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc rootDoc) {
        String string = DocletUtil.getOption("-version", rootDoc.options());
        String string2 = DocletUtil.getOption("-outfile", rootDoc.options());
        DocletTagWriter docletTagWriter = null;
        try {
            docletTagWriter = new DocletTagWriter(string2, ENCODE, true);
            docletTagWriter.printTag("<?xml version=\"1.0\" encoding=\"", ENCODE, "\" ?>");
            docletTagWriter.printTag("<javadoc>");
            docletTagWriter.printTag("  <version>", string, "</version>");
            docletTagWriter.printTag("  <description></description>");
            DocletSpecific.writeContents(rootDoc.classes(), docletTagWriter);
            docletTagWriter.printTag("</javadoc>");
        }
        catch (IOException iOException) {
            LogWriter.log(iOException);
        }
        finally {
            if (docletTagWriter != null) {
                docletTagWriter.close();
            }
        }
        return true;
    }

    private static void writeContents(ClassDoc[] classDocArray, DocletTagWriter docletTagWriter) {
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassDoc classDoc = classDocArray[i];
            String string = classDoc.name();
            String string2 = classDoc.qualifiedName();
            String string3 = (classDoc.modifiers() + (classDoc.isClass() ? " class" : "")).trim();
            Type type = classDoc.superclassType();
            String string4 = type == null ? "" : type.qualifiedTypeName();
            Type[] typeArray = classDoc.interfaceTypes();
            StringBuilder stringBuilder = new StringBuilder(200);
            for (int j = 0; j < typeArray.length; ++j) {
                stringBuilder.append(typeArray[j].qualifiedTypeName()).append(",");
            }
            if (typeArray.length > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            String string5 = stringBuilder.toString();
            Tag[] tagArray = classDoc.firstSentenceTags();
            String string6 = DocletUtil.htmlFilter(classDoc.commentText());
            Tag[] tagArray2 = classDoc.tags(OG_FOR_SMPL);
            Tag[] tagArray3 = classDoc.tags(OG_REV);
            Tag[] tagArray4 = classDoc.tags(DOC_VERSION);
            Tag[] tagArray5 = classDoc.tags(DOC_AUTHOR);
            Tag[] tagArray6 = classDoc.tags(DOC_SINCE);
            Tag[] tagArray7 = classDoc.tags(OG_GROUP);
            docletTagWriter.printTag("<classDoc>");
            docletTagWriter.printTag("  <fullName>", string2, "</fullName>");
            docletTagWriter.printTag("  <className>", string, "</className>");
            docletTagWriter.printTag("  <modifiers>", string3, "</modifiers>");
            docletTagWriter.printTag("  <superClass>", string4, "</superClass>");
            docletTagWriter.printTag("  <interface>", string5, "</interface>");
            docletTagWriter.printTag("  <createVer>", tagArray4, "</createVer>");
            docletTagWriter.printTag("  <author>", tagArray5, "</author>");
            docletTagWriter.printTag("  <since>", tagArray6, "</since>");
            docletTagWriter.printTag("  <description>", tagArray, "</description>");
            docletTagWriter.printTag("  <contents>", string6, "</contents>");
            docletTagWriter.printTag("  <classGroup>");
            docletTagWriter.printCSVTag(tagArray7);
            docletTagWriter.printTag("</classGroup>");
            docletTagWriter.printTag("  <formSample>", tagArray2, "</formSample>");
            docletTagWriter.printTag("  <history>", tagArray3, "</history>");
            methodSet.clear();
            int n = 0;
            while (true) {
                ConstructorDoc[] constructorDocArray = classDoc.constructors();
                for (int j = 0; j < constructorDocArray.length; ++j) {
                    if (!DocletSpecific.isAction((ExecutableMemberDoc)constructorDocArray[j], n)) continue;
                    DocletSpecific.menberTag((ExecutableMemberDoc)constructorDocArray[j], CONSTRUCTOR, docletTagWriter, n);
                }
                MethodDoc[] methodDocArray = classDoc.methods();
                for (int j = 0; j < methodDocArray.length; ++j) {
                    if (!DocletSpecific.isAction((ExecutableMemberDoc)methodDocArray[j], n)) continue;
                    DocletSpecific.menberTag((ExecutableMemberDoc)methodDocArray[j], METHOD, docletTagWriter, n);
                }
                Type type2 = classDoc.superclassType();
                if (type2 == null || "java.lang.Object".equals(string2 = (classDoc = type2.asClassDoc()).qualifiedName())) break;
                if (string2.startsWith(SELECT_PACKAGE)) {
                    n = 1;
                    continue;
                }
                n = 2;
            }
            docletTagWriter.printTag("  </classDoc>");
        }
    }

    private static boolean isAction(ExecutableMemberDoc executableMemberDoc, int n) {
        String string = executableMemberDoc.name();
        String string2 = string + executableMemberDoc.signature();
        boolean bl = !methodSet.add(string2) || n > 0 && executableMemberDoc.isPrivate() || string.charAt(0) == '<';
        return !bl;
    }

    private static void menberTag(ExecutableMemberDoc executableMemberDoc, String string, DocletTagWriter docletTagWriter, int n) {
        String string2;
        StringBuilder stringBuilder;
        Object object;
        if (executableMemberDoc instanceof MethodDoc) {
            object = ((MethodDoc)executableMemberDoc).returnType();
            stringBuilder = new StringBuilder(200);
            stringBuilder.append(executableMemberDoc.modifiers());
            stringBuilder.append(" ").append(object.qualifiedTypeName());
            if (object.dimension() != null) {
                stringBuilder.append(object.dimension());
            }
            string2 = stringBuilder.toString();
        } else {
            string2 = executableMemberDoc.modifiers();
        }
        object = executableMemberDoc.name();
        stringBuilder = new StringBuilder(200);
        stringBuilder.append((String)object).append("(");
        Parameter[] parameterArray = executableMemberDoc.parameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            stringBuilder.append(parameterArray[i].toString()).append(",");
        }
        if (parameterArray.length > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(")");
        String string3 = stringBuilder.toString();
        Tag[] tagArray = executableMemberDoc.firstSentenceTags();
        String string4 = DocletUtil.htmlFilter(executableMemberDoc.commentText());
        Tag[] tagArray2 = executableMemberDoc.tags();
        Tag[] tagArray3 = executableMemberDoc.tags(OG_REV);
        String string5 = String.valueOf(n);
        String string6 = n == 0 ? "" : executableMemberDoc.containingClass().qualifiedName();
        docletTagWriter.printTag("  <menber>");
        docletTagWriter.printTag("    <type>", string, "</type>");
        docletTagWriter.printTag(new String[]{"    <name>", object, "</name>"});
        docletTagWriter.printTag("    <modifiers>", string2, "</modifiers>");
        docletTagWriter.printTag("    <signature>", string3, "</signature>");
        docletTagWriter.printTag("    <extendClass>", string6, "</extendClass>");
        docletTagWriter.printTag("    <extendFlag>", string5, "</extendFlag>");
        docletTagWriter.printTag("    <description>", tagArray, "</description>");
        docletTagWriter.printTag("    <contents>", string4, "</contents>");
        docletTagWriter.printTag("    <tagText>");
        docletTagWriter.printTagsInfo(tagArray2);
        docletTagWriter.printTag("    </tagText>");
        docletTagWriter.printTag("    <history>", tagArray3, "</history>");
        docletTagWriter.printTag("  </menber>");
    }

    public static int optionLength(String string) {
        if (string.equalsIgnoreCase("-version")) {
            return 2;
        }
        if (string.equalsIgnoreCase("-outfile")) {
            return 2;
        }
        return 0;
    }
}

