/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.model.ArrayDataModel;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class DirectTableInsertTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String TAB_SEPARATOR = "\t";
    private String dbid = null;
    private String separator = "\t";
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private String displayMsg = "MSG0040";
    private String[] columns = null;
    private String[] clmKeys = null;
    private String sql = null;
    private int commitBatch = 0;
    private boolean useColumnCheck = false;
    private boolean useColumnAdjust = false;
    private String[] nullCheck = null;
    private long dyStart = 0L;

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString();
        if (this.sql == null || this.sql.length() == 0) {
            String string = "BODY \u90e8\u306e\u767b\u9332\u7528 Insert/Update\u6587\u306f\u3001\u5fc5\u9808\u3067\u3059\u3002";
            throw new HybsSystemException(string);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        BufferedReader bufferedReader = this.getBufferedReader();
        int n = this.create(bufferedReader);
        Closer.ioClose((Closeable)bufferedReader);
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            String string = n + this.getResource().getLabel(this.displayMsg);
            this.jspPrint(string + HybsSystem.BR);
        }
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        GUIInfo gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (gUIInfo != null) {
            gUIInfo.addWriteCount(n, l, this.sql);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.dbid = null;
        this.separator = TAB_SEPARATOR;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.displayMsg = "MSG0040";
        this.columns = null;
        this.useColumnCheck = false;
        this.useColumnAdjust = false;
        this.nullCheck = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int create(BufferedReader var1_1) {
        block18: {
            var2_2 = this.readName(var1_1);
            var3_3 = var2_2.length;
            var4_4 = new ArrayDataModel(var2_2);
            var5_5 = new Formatter((DataModel)var4_4);
            var5_5.setFormat(this.sql.trim());
            this.sql = var5_5.getQueryFormatString();
            var6_6 = var5_5.getClmNos();
            var7_7 = var6_6.length;
            this.clmKeys = var5_5.getClmKeys();
            var8_8 = new CheckColumnData(var6_6, this.clmKeys, this.getResource());
            var9_9 = new ArrayDataModel(var2_2);
            var10_10 = var9_9.getColumnNos(this.nullCheck);
            var11_11 = var10_10.length;
            var12_12 = 0;
            var13_13 = 0;
            var14_14 = this.separator.charAt(0);
            var15_15 = true;
            var16_16 = null;
            var17_17 = null;
            var18_18 = null;
            try {
                var16_16 = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.getApplicationInfo());
                var17_17 = var16_16.prepareStatement(this.sql);
lbl24:
                // 3 sources

                while ((var19_19 = var1_1.readLine()) != null) {
                    if (var19_19.length() == 0 || var19_19.charAt(0) == '#') continue;
                    var18_18 = StringUtil.csv2Array((String)var19_19, (char)var14_14, (int)var3_3);
                    if (this.useColumnAdjust) {
                        var18_18 = var8_8.adjustData(var18_18);
                    }
                    if (this.useColumnCheck && !(var20_23 = var8_8.checkData(var12_12, var18_18)).isOK()) {
                        var16_16.rollback();
                        this.jspPrint(TaglibUtil.makeHTMLErrorTable((ErrorMessage)var20_23, this.getResource()));
                        var21_24 = var13_13;
                        break block18;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl91
            }
            catch (IOException var19_20) {
                try {
                    var20_23 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + var1_1.toString() + "]" + " \u884c\u756a\u53f7=[" + var12_12 + "]" + " \u767b\u9332\u4ef6\u6570=[" + var13_13 + "]";
                    throw new HybsSystemException(var20_23, var19_20);
                    catch (SQLException var19_21) {
                        var20_23 = "sql=[" + this.sql + "]" + HybsSystem.CR + "names=[" + StringUtil.array2csv((String[])var2_2) + "]" + HybsSystem.CR + "vals =[" + StringUtil.array2csv(var18_18) + "]" + HybsSystem.CR + " \u884c\u756a\u53f7=[" + var12_12 + "]" + " \u767b\u9332\u4ef6\u6570=[" + var13_13 + "]" + HybsSystem.CR + " errorCode=[" + var19_21.getErrorCode() + "] State=[" + var19_21.getSQLState() + "]" + HybsSystem.CR;
                        throw new HybsSystemException(var20_23, var19_21);
                    }
                }
                catch (Throwable var24_29) {
                    Closer.stmtClose(var17_17);
                    if (var15_15) {
                        ConnectionFactory.remove((Connection)var16_16, (String)this.dbid);
                        throw var24_29;
                    }
                    ConnectionFactory.close((Connection)var16_16, (String)this.dbid);
                    throw var24_29;
                }
            }
        }
        Closer.stmtClose((Statement)var17_17);
        if (var15_15) {
            ConnectionFactory.remove((Connection)var16_16, (String)this.dbid);
            return var21_24;
        }
        ConnectionFactory.close((Connection)var16_16, (String)this.dbid);
        return var21_24;
lbl-1000:
        // 1 sources

        {
            if (var11_11 <= 0) ** GOTO lbl-1000
            var20_23 = new ErrorMessage("Null Check Columns Error!");
            for (var21_25 = 0; var21_25 < var11_11; ++var21_25) {
                var22_27 = var10_10[var21_25];
                if (var18_18[var22_27] != null && var18_18[var22_27].length() != 0) continue;
                var23_28 = this.getResource().getLabel(this.nullCheck[var21_25]);
                var20_23.addMessage(var12_12 + 1, 2, "ERR0012", new String[]{var23_28});
            }
            if (var20_23.isOK()) ** GOTO lbl-1000
            var16_16.rollback();
            this.jspPrint(TaglibUtil.makeHTMLErrorTable((ErrorMessage)var20_23, this.getResource()));
            var21_25 = var13_13;
        }
        Closer.stmtClose((Statement)var17_17);
        if (var15_15) {
            ConnectionFactory.remove((Connection)var16_16, (String)this.dbid);
            return var21_25;
        }
        ConnectionFactory.close((Connection)var16_16, (String)this.dbid);
        return var21_25;
lbl-1000:
        // 3 sources

        {
            for (var20_22 = 0; var20_22 < var7_7; ++var20_22) {
                var21_26 = var18_18[var6_6[var20_22]];
                if (var21_26 != null && var21_26.startsWith("'0")) {
                    var21_26 = var21_26.substring(1);
                }
                var17_17.setObject(var20_22 + 1, var21_26);
            }
            var17_17.execute();
            if (this.commitBatch > 0 && var12_12 % this.commitBatch == 0) {
                var16_16.commit();
                var13_13 = var12_12;
            }
            ++var12_12;
            ** GOTO lbl24
lbl91:
            // 1 sources

            var16_16.commit();
            var13_13 = var12_12;
            var15_15 = false;
        }
        Closer.stmtClose((Statement)var17_17);
        if (var15_15) {
            ConnectionFactory.remove((Connection)var16_16, (String)this.dbid);
            return var13_13;
        }
        ConnectionFactory.close((Connection)var16_16, (String)this.dbid);
        return var13_13;
    }

    private String[] readName(BufferedReader bufferedReader) {
        String string;
        if (this.columns != null && this.columns.length > 0) {
            return this.columns;
        }
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                if (string.charAt(0) == '#') {
                    if (string.length() < 5 || !"#NAME".equalsIgnoreCase(string.substring(0, 5))) continue;
                    String[] stringArray = StringUtil.csv2Array((String)string, (char)TAB_SEPARATOR.charAt(0));
                    stringArray[0] = "ROW_NO";
                    return stringArray;
                }
                String string2 = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002";
                throw new HybsSystemException(string2);
            }
        }
        catch (IOException iOException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + bufferedReader.toString() + "]";
            throw new HybsSystemException(string3, iOException);
        }
        string = "#NAME \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        throw new HybsSystemException(string);
    }

    private BufferedReader getBufferedReader() {
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        String string = HybsSystem.url2dir(this.fileURL);
        File file = new File(StringUtil.urlAppend((String)string, (String)this.filename));
        BufferedReader bufferedReader = FileUtil.getBufferedReader((File)file, (String)this.encode);
        return bufferedReader;
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setDisplayMsg(String string) {
        if (string != null) {
            this.displayMsg = string;
        }
    }

    public void setColumns(String string) {
        this.columns = StringUtil.csv2Array((String)StringUtil.nval((String)this.getRequestParameter(string), null), (char)',');
    }

    public void setCommitBatch(String string) {
        this.commitBatch = StringUtil.nval((String)this.getRequestParameter(string), (int)this.commitBatch);
    }

    public void setUseColumnCheck(String string) {
        this.useColumnCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useColumnCheck);
    }

    public void setUseColumnAdjust(String string) {
        this.useColumnAdjust = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useColumnAdjust);
    }

    public void setNullCheck(String string) {
        this.nullCheck = StringUtil.csv2Array((String)this.getRequestParameter(string));
        if (this.nullCheck.length == 0) {
            this.nullCheck = null;
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("separator", (Object)this.separator).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("encode", (Object)this.encode).println("displayMsg", (Object)this.displayMsg).println("columns", (Object[])this.columns).println("clmKeys", (Object[])this.clmKeys).println("sql", (Object)this.sql).println("commitBatch", (Object)this.commitBatch).println("useColumnCheck", (Object)this.useColumnCheck).println("useColumnAdjust", (Object)this.useColumnAdjust).println("nullCheck", (Object[])this.nullCheck).println("dyStart", (Object)this.dyStart).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    static class CheckColumnData {
        private final DBColumn[] dbClm;
        private final int[] clmChkNo;
        private final int len;
        private final ErrorMessage errMsg = new ErrorMessage("Check Columns Error!");

        CheckColumnData(int[] nArray, String[] stringArray, ResourceManager resourceManager) {
            if (nArray == null || nArray.length == 0 || stringArray == null || stringArray.length == 0) {
                this.dbClm = null;
                this.clmChkNo = null;
                this.len = 0;
            } else {
                this.clmChkNo = nArray;
                this.len = nArray.length;
                this.dbClm = new DBColumn[this.len];
                for (int i = 0; i < this.len; ++i) {
                    this.dbClm[i] = resourceManager.makeDBColumn(stringArray[i]);
                }
            }
        }

        String[] adjustData(String[] stringArray) {
            if (this.len == 0) {
                return stringArray;
            }
            String[] stringArray2 = new String[this.len];
            for (int i = 0; i < this.len; ++i) {
                String string = stringArray[this.clmChkNo[i]];
                stringArray2[i] = this.dbClm[i].valueSet(string);
            }
            return stringArray2;
        }

        ErrorMessage checkData(int n, String[] stringArray) {
            for (int i = 0; i < this.len; ++i) {
                String string = stringArray[this.clmChkNo[i]];
                this.errMsg.append(n + 1, this.dbClm[i].valueCheck(string));
            }
            return this.errMsg;
        }
    }
}

