/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.GUIData;

final class GUIDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY = "select GUIKEY,GUILVL,LABEL_CLM,ADDRESS,SEQNO,GROUPS,'',ROLES,RWMODE,TARGET,PARAM,KBLINK from GEA11 where SYSTEM_ID in ( ?,'**') and FGJ='1' order by SYSTEM_ID,KBSAKU,SEQNO,GUIKEY";
    private final List<GUIData> pool = Collections.synchronizedList(new ArrayList());
    private final String SYSTEM_ID;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    GUIDataLoader(String string) {
        this.SYSTEM_ID = string;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("CodeDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        this.loadDBResource();
    }

    private void loadDBResource() {
        String[] stringArray = new String[]{this.SYSTEM_ID};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        int n = stringArray2.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            int n2 = Integer.parseInt(stringArray2[i][1]);
            if (n2 == 2) {
                string = stringArray2[i][0];
            } else if (n2 >= 3) {
                stringArray2[i][6] = string;
            }
            if (!(n2 != 1 && n2 != 2 || stringArray2[i][3] != null && stringArray2[i][3].length() != 0)) {
                stringArray2[i][7] = null;
            }
            this.pool.add(new GUIData(stringArray2[i]));
        }
        System.out.println("  GUIDataLoader [" + n + "] loaded");
    }

    public GUIData[] getAllData() {
        if (this.pool.isEmpty()) {
            this.loadDBResource();
        }
        return this.pool.toArray(new GUIData[this.pool.size()]);
    }

    public void clear() {
        this.pool.clear();
    }
}

