/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.LabelInterface;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class MessageTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private String comment = null;
    private String[] values = null;
    private String type = "Label";
    private String cmdMsg = null;
    private static final String[] TYPE_LIST = new String[]{"Label", "Short", "Tips", "Description"};

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        String string = this.getBodyString();
        if (string != null && string.length() > 0) {
            this.comment = StringUtil.htmlFilter((String)string);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            this.jspPrint(this.makeTag());
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.comment = null;
        this.values = null;
        this.type = "Label";
        this.cmdMsg = null;
    }

    private String makeTag() {
        String string = null;
        LabelInterface labelInterface = this.getLabelInterface();
        char c = this.type.charAt(0);
        if (labelInterface != null) {
            switch (c) {
                case 'L': {
                    string = labelInterface.getMessage(this.values);
                    break;
                }
                case 'S': {
                    string = labelInterface.getShortLabel();
                    break;
                }
                case 'T': {
                    string = labelInterface.getLongLabel();
                    break;
                }
                case 'D': {
                    string = labelInterface.getDescription();
                    break;
                }
            }
        } else {
            string = this.cmdMsg != null ? this.getResource().getLabel(this.cmdMsg) : this.comment;
        }
        return string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setType(String string) {
        this.type = StringUtil.nval((String)this.getRequestParameter(string), (String)this.type);
        char c = this.type.charAt(0);
        if ("LSTD".indexOf(c) < 0) {
            String string2 = "type \u306b\u3001\u6307\u5b9a\u4e0d\u53ef\u80fd\u306a\u6587\u5b57\u304c\u8a2d\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002type=[" + this.type + "] TYPE_LIST=[" + StringUtil.array2csv((String[])TYPE_LIST) + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setVal0(String string) {
        this.setValues(0, string);
    }

    public void setVal1(String string) {
        this.setValues(1, string);
    }

    public void setVal2(String string) {
        this.setValues(2, string);
    }

    public void setVal3(String string) {
        this.setValues(3, string);
    }

    public void setVal4(String string) {
        this.setValues(4, string);
    }

    public void setVal5(String string) {
        this.setValues(5, string);
    }

    public void setVal6(String string) {
        this.setValues(6, string);
    }

    public void setVal7(String string) {
        this.setValues(7, string);
    }

    public void setVal8(String string) {
        this.setValues(8, string);
    }

    public void setVal9(String string) {
        this.setValues(9, string);
    }

    private void setValues(int n, String string) {
        if (this.values == null) {
            this.values = new String[10];
        }
        this.values[n] = this.getRequestParameter(string);
    }

    public void setCommand(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.cmdMsg = "INSERT".equalsIgnoreCase(string2) ? "MSG0044" : ("COPY".equalsIgnoreCase(string2) ? "MSG0045" : ("MODIFY".equalsIgnoreCase(string2) ? "MSG0046" : ("DELETE".equalsIgnoreCase(string2) ? "MSG0047" : null)));
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("comment", (Object)this.comment).println("values", (Object[])this.values).println("type", (Object)this.type).println("TYPE_LIST", (Object[])TYPE_LIST).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

