/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.taglib.QueryTag;

public class FileQueryTag
extends QueryTag {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String[] SELECT = new String[]{"LEVEL", "FILE_TYPE", "PARENT", "NAME", "LASTMODIFIED", "FILE_LENGTH", "RWH"};
    private static final int LEVEL = 0;
    private static final int FILE_TYPE = 1;
    private static final int PARENT = 2;
    private static final int NAME = 3;
    private static final int LASTMODIFIED = 4;
    private static final int FILE_LENGTH = 5;
    private static final int RWH = 6;
    private boolean multi = false;
    private int level = 100;
    private String from = HybsSystem.sys("FILE_URL");
    private transient FileFilter filter = null;

    @Override
    public int doAfterBody() {
        this.executeCount = 0;
        this.table = this.initDBTable();
        if (this.maxRowCount < 0) {
            this.maxRowCount = this.sysInt("DB_MAX_ROW_COUNT");
        }
        this.execute(new File(this.from), 0);
        return 0;
    }

    @Override
    protected void release2() {
        super.release2();
        this.multi = false;
        this.level = 100;
        this.from = HybsSystem.sys("FILE_URL");
        this.filter = null;
    }

    protected void execute(File file, int n) {
        if (!this.multi && n > 1 || n > this.level) {
            return;
        }
        if (this.executeCount > this.maxRowCount) {
            this.table.setOverflow(true);
            return;
        }
        this.addFileData(this.executeCount++, n, file);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(this.filter);
            for (int i = 0; i < fileArray.length; ++i) {
                this.execute(fileArray[i], n + 1);
            }
        }
    }

    private DBTableModel initDBTable() {
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(SELECT.length);
        for (int i = 0; i < SELECT.length; ++i) {
            DBColumn dBColumn = this.getDBColumn(SELECT[i]);
            dBTableModel.setDBColumn(i, dBColumn);
        }
        return dBTableModel;
    }

    private void addFileData(int n, int n2, File file) {
        try {
            File file2 = file.getCanonicalFile();
            String string = (file2.canRead() ? "r" : "-") + (file2.canWrite() ? "w" : "-") + (file2.isHidden() ? "h" : "-");
            String string2 = HybsSystem.getDate(file2.lastModified(), "yyyyMMddHHmmss");
            String[] stringArray = new String[SELECT.length];
            stringArray[0] = String.valueOf(n2);
            stringArray[1] = file2.isFile() ? "F" : "D";
            stringArray[2] = file2.getParent();
            stringArray[3] = file2.getName();
            stringArray[4] = string2;
            stringArray[5] = String.valueOf(file2.length());
            stringArray[6] = string;
            this.table.addColumnValues(stringArray);
        }
        catch (IOException iOException) {
            String string = "\u6b63\u5f0f\u306a\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + file + "]" + " ROW=[" + n + "]" + HybsSystem.CR + iOException.getMessage();
            throw new HybsSystemException(string, iOException);
        }
    }

    public void setFrom(String string) {
        char c;
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null && (c = string2.charAt(string2.length() - 1)) != '/' && c != '\\') {
            string2 = string2 + "/";
        }
        string2 = StringUtil.urlAppend((String)this.from, (String)string2);
        string2 = StringUtil.urlAppend((String)string2, (String)".");
        this.from = HybsSystem.url2dir(string2);
    }

    public void setMulti(String string) {
        this.multi = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.multi);
    }

    public void setLevel(String string) {
        this.level = StringUtil.nval((String)this.getRequestParameter(string), (int)this.level);
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("multi", (Object)this.multi).println("level", (Object)this.level).println("from", (Object)this.from).fixForm().toString() + HybsSystem.CR + super.toString();
    }
}

