/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.SystemParameter;

public class Process_DBWriter
extends AbstractProcess
implements ChainProcess {
    private static final String CNST_KEY = "const_";
    private static final String SQL_KEY = "sql_";
    private Connection connection = null;
    private PreparedStatement pstmt = null;
    private ParameterMetaData pMeta = null;
    private boolean useParamMetaData = false;
    private String dbid = null;
    private String sql = null;
    private String table = null;
    private int[] clmNos = null;
    private int commitCnt = 0;
    private boolean display = false;
    private String[] cnstClm = null;
    private int[] cnstClmNos = null;
    private String[] constVal = null;
    private boolean firstRow = true;
    private int count = 0;
    private String[] omitClms = null;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty = new LinkedHashMap<String, String>();

    public Process_DBWriter() {
        super("org.opengion.fukurou.process.Process_DBWriter", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.table = argument.getProparty("table");
        this.sql = argument.getFileProparty("sql", "sqlFile", false);
        this.commitCnt = argument.getProparty("commitCnt", this.commitCnt);
        this.display = argument.getProparty("display", this.display);
        this.dbid = argument.getProparty("dbid");
        this.connection = paramProcess.getConnection(this.dbid);
        this.useParamMetaData = ApplicationInfo.useParameterMetaData(this.connection);
        String string = argument.getProparty("omitClms", null);
        if (string != null) {
            this.omitClms = StringUtil.csv2Array(string);
        }
        if (this.sql == null && this.table == null) {
            String string2 = "sql \u3092\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u3001table \u3092\u5fc5\u305a\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            throw new RuntimeException(string2);
        }
        HybsEntry[] hybsEntryArray = argument.getEntrys(SQL_KEY);
        SystemParameter systemParameter = new SystemParameter(this.sql);
        this.sql = systemParameter.replace(hybsEntryArray);
        HybsEntry[] hybsEntryArray2 = argument.getEntrys(CNST_KEY);
        int n = hybsEntryArray2.length;
        this.cnstClm = new String[n];
        this.constVal = new String[n];
        for (int i = 0; i < n; ++i) {
            this.cnstClm[i] = hybsEntryArray2[i].getKey();
            this.constVal[i] = hybsEntryArray2[i].getValue();
        }
    }

    @Override
    public void end(boolean bl) {
        boolean bl2 = Closer.stmtClose(this.pstmt);
        this.pstmt = null;
        this.pMeta = null;
        if (bl) {
            Closer.commit(this.connection);
        } else {
            Closer.rollback(this.connection);
        }
        ConnectionFactory.remove(this.connection, this.dbid);
        if (!bl2) {
            String string = "\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string);
        }
    }

    @Override
    public LineModel action(LineModel lineModel) {
        ++this.count;
        try {
            int n;
            int n2;
            if (this.firstRow) {
                this.pstmt = this.makePrepareStatement(this.table, lineModel);
                if (this.useParamMetaData) {
                    this.pMeta = this.pstmt.getParameterMetaData();
                }
                n2 = this.cnstClm.length;
                this.cnstClmNos = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this.cnstClmNos[n] = lineModel.getColumnNo(this.cnstClm[n]);
                }
                this.firstRow = false;
            }
            for (n2 = 0; n2 < this.cnstClmNos.length; ++n2) {
                lineModel.setValue(this.cnstClmNos[n2], this.constVal[n2]);
            }
            if (this.useParamMetaData) {
                for (n2 = 0; n2 < this.clmNos.length; ++n2) {
                    n = this.pMeta.getParameterType(n2 + 1);
                    this.pstmt.setObject(n2 + 1, lineModel.getValue(this.clmNos[n2]), n);
                }
            } else {
                for (n2 = 0; n2 < this.clmNos.length; ++n2) {
                    this.pstmt.setObject(n2 + 1, lineModel.getValue(this.clmNos[n2]));
                }
            }
            this.pstmt.execute();
            if (this.commitCnt > 0 && this.count % this.commitCnt == 0) {
                Closer.commit(this.connection);
            }
        }
        catch (SQLException sQLException) {
            String string = "sql=[" + this.sql + "]" + CR + "errorCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR;
            throw new RuntimeException(string, sQLException);
        }
        if (this.display) {
            this.println(lineModel.dataLine());
        }
        return lineModel;
    }

    private PreparedStatement makePrepareStatement(String string, LineModel lineModel) {
        Object object;
        if (this.sql == null) {
            int n;
            object = new StringBuilder();
            String[] stringArray = lineModel.getNames();
            if (this.omitClms != null) {
                HashSet<String> hashSet = new HashSet<String>();
                for (n = 0; n < stringArray.length; ++n) {
                    hashSet.add(stringArray[n]);
                }
                for (n = 0; n < this.omitClms.length; ++n) {
                    hashSet.remove(this.omitClms[n]);
                }
                stringArray = hashSet.toArray(new String[hashSet.size()]);
            }
            int n2 = stringArray.length;
            ((StringBuilder)object).append("INSERT INTO ").append(string).append(" (");
            ((StringBuilder)object).append(stringArray[0]);
            for (n = 1; n < n2; ++n) {
                ((StringBuilder)object).append(",").append(stringArray[n]);
            }
            ((StringBuilder)object).append(" ) VALUES ( ?");
            for (n = 1; n < n2; ++n) {
                ((StringBuilder)object).append(",?");
            }
            ((StringBuilder)object).append(" )");
            this.sql = ((StringBuilder)object).toString();
            this.clmNos = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.clmNos[n] = lineModel.getColumnNo(stringArray[n]);
            }
        } else {
            object = new Formatter(lineModel);
            ((Formatter)object).setFormat(this.sql);
            this.sql = ((Formatter)object).getQueryFormatString();
            this.clmNos = ((Formatter)object).getClmNos();
        }
        try {
            object = this.connection.prepareStatement(this.sql);
        }
        catch (SQLException sQLException) {
            String string2 = "PreparedStatement \u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "sql=[" + this.sql + "]" + CR + "table=[" + string + "]" + CR + "nameLine=[" + lineModel.nameLine() + "]";
            throw new RuntimeException(string2, sQLException);
        }
        return object;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "DBID         : " + this.dbid + CR + "\t" + "Output Count : " + this.count;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_DBWriter \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f\u30c7\u30fc\u30bf\u3092\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u66f8\u304d\u8fbc\u3080").append(CR);
        stringBuilder.append("CainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u4e0a\u6d41\uff08\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002\uff09\u304b\u3089").append(CR);
        stringBuilder.append("\u53d7\u3051\u53d6\u3063\u305f LineModel \u3092\u5143\u306b\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3078\u306e\u66f8\u304d\u8fbc\u307f\u3092\u884c\u3044\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5148\u7b49\u306f\u3001ParamProcess \u306e\u30b5\u30d6\u30af\u30e9\u30b9(Process_DBParam)\u306b").append(CR);
        stringBuilder.append("\u8a2d\u5b9a\u3055\u308c\u305f\u63a5\u7d9a(Connection)\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("SQL\u6587\u306b\u306f\u3001{@SYS.YMDH}\u7b49\u306e\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR);
        stringBuilder.append("\u73fe\u6642\u70b9\u3067\u306f\u3001{@SYS.YMD}\u3001{@SYS.YMDH}\u3001{@SYS.HMS} \u304c\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_DBWriter().usage());
    }

    static {
        usableProparty.put("dbid", "Process_DBParam \u306e -configFile \u3067\u6307\u5b9a\u3059\u308b DBConfig.xml \u30d5\u30a1\u30a4\u30eb\u3067\u898f\u5b9a");
        usableProparty.put("table", "INSERT \u3059\u308b\u5834\u5408\u306e\u30c6\u30fc\u30d6\u30ebID SQL\u6587\u3092\u6307\u5b9a\u3059\u308b\u5834\u5408\u306f\u4e0d\u8981\u3002");
        usableProparty.put("sql", "\u66f4\u65b0SQL\u6587\uff08sql or sqlFile \u5fc5\u9808\uff09" + CR + "\u4f8b: \"UPDATE GE41 " + CR + "SET NAME_JA = [NAME_JA],LABEL_NAME = [LABEL_NAME] " + CR + "WHERE SYSTEM_ID = [SYSTEM_ID] AND CLM = [CLM]\"");
        usableProparty.put("sqlFile", "\u767b\u9332SQL\u30d5\u30a1\u30a4\u30eb\uff08sql or sqlFile \u5fc5\u9808\uff09\u4f8b: update.sql");
        usableProparty.put(SQL_KEY, "SQL\u6587\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092\u6307\u5b9a\u306e\u56fa\u5b9a\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID='{&#064;SYSTEM_ID}' \u21d2 WHERE SYSTEM_ID='GE'");
        usableProparty.put(CNST_KEY, "LineModel \u306e\u30ad\u30fc\uff08const_ \u306b\u7d9a\u304f\u6587\u5b57\u5217)\u306e\u5024\u306b\u3001\u56fa\u5b9a\u5024\u3092" + CR + "\u8a2d\u5b9a\u3057\u307e\u3059\u3002\u30ad\u30fc\u304c\u7570\u306a\u308c\u3070\u3001\u8907\u6570\u306e\u30ab\u30e9\u30e0\u540d\u3092\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + CR + "\u4f8b: -sql_SYSTEM_ID=GE");
        usableProparty.put("omitClms", "-table \u5c5e\u6027\u3067INSERT\u6587\u3092\u81ea\u52d5\u4f5c\u6210\u3059\u308b\u5834\u5408\u3001\u53d6\u308a\u9664\u304f\u30ab\u30e9\u30e0\u540d\u3092" + CR + "\u30ab\u30f3\u30de\u533a\u5207\u308a\u3067\u8907\u6570\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + CR + "\u4f8b: -omitClms=UNIQ,FGJ,DYSET");
        usableProparty.put("commitCnt", "\u6307\u5b9a\u6570\u6bce\u306b\u30b3\u30df\u30c3\u30c8\u3092\u767a\u884c\u3057\u307e\u3059\u3002" + CR + "0 \u306e\u5834\u5408\u306f\u3001\u7d42\u4e86\u307e\u3067\u30b3\u30df\u30c3\u30c8\u3057\u307e\u305b\u3093\u3002(\u521d\u671f\u5024: 0)");
        usableProparty.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024 false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

