/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.taglib.QueryTag;

public class FileQueryTag
extends QueryTag {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String[] SELECT = new String[]{"LEVEL", "FILE_TYPE", "PARENT", "NAME", "LASTMODIFIED", "FILE_LENGTH", "RWH"};
    private static final int LEVEL = 0;
    private static final int FILE_TYPE = 1;
    private static final int PARENT = 2;
    private static final int NAME = 3;
    private static final int LASTMODIFIED = 4;
    private static final int FILE_LENGTH = 5;
    private static final int RWH = 6;
    private static final String[] USE_UPDATE_CLM = new String[]{"TO_PARENT", "TO_NAME"};
    private transient FileFilter filter = null;
    private boolean multi = false;
    private int level = 100;
    private String from = HybsSystem.sys("FILE_URL");
    private String orderBy = null;
    private boolean desc = false;
    private String[] addClms = new String[0];
    private String[] valClms = null;
    private String fileType = null;
    private boolean useUpdateClms = false;

    @Override
    public int doAfterBody() {
        this.executeCount = 0;
        this.table = this.initDBTable();
        if (this.maxRowCount < 0) {
            this.maxRowCount = this.sysInt("DB_MAX_ROW_COUNT");
        }
        this.execute(new File(this.from), 0);
        if (this.orderBy != null) {
            int n = this.table.getColumnNo(this.orderBy);
            DBTableModelSorter dBTableModelSorter = new DBTableModelSorter();
            dBTableModelSorter.setModel(this.table);
            dBTableModelSorter.sortByColumn(n, !this.desc);
            this.table = dBTableModelSorter;
        }
        return 0;
    }

    @Override
    protected void release2() {
        super.release2();
        this.multi = false;
        this.level = 100;
        this.from = HybsSystem.sys("FILE_URL");
        this.filter = null;
        this.orderBy = null;
        this.desc = false;
        this.addClms = new String[0];
        this.valClms = null;
        this.fileType = null;
        this.useUpdateClms = false;
    }

    protected void execute(File file, int n) {
        if (!this.multi && n > 1 || n > this.level) {
            return;
        }
        if (this.executeCount > this.maxRowCount) {
            this.table.setOverflow(true);
            return;
        }
        boolean bl = file.isDirectory();
        if (this.fileType == null || bl && "DIR".equalsIgnoreCase(this.fileType) || !bl && "FILE".equalsIgnoreCase(this.fileType)) {
            this.addFileData(this.executeCount++, n, file);
        }
        if (bl) {
            File[] fileArray = file.listFiles(this.filter);
            for (int i = 0; i < fileArray.length; ++i) {
                this.execute(fileArray[i], n + 1);
            }
        }
    }

    private DBTableModel initDBTable() {
        DBColumn dBColumn;
        int n;
        int n2;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        int n3 = this.addClms.length;
        if (this.useUpdateClms) {
            if (n3 == 0) {
                this.addClms = USE_UPDATE_CLM;
            } else {
                this.addClms = Arrays.copyOf(this.addClms, n3 + USE_UPDATE_CLM.length);
                for (n2 = 0; n2 < USE_UPDATE_CLM.length; ++n2) {
                    this.addClms[n3 + n2] = USE_UPDATE_CLM[n2];
                }
            }
        }
        this.valClms = new String[this.addClms.length];
        dBTableModel.init(SELECT.length + this.addClms.length);
        n2 = 0;
        for (n = 0; n < SELECT.length; ++n) {
            dBColumn = this.getDBColumn(SELECT[n]);
            dBTableModel.setDBColumn(n2++, dBColumn);
        }
        for (n = 0; n < this.addClms.length; ++n) {
            dBColumn = this.getDBColumn(this.addClms[n]);
            this.valClms[n] = dBColumn.getDefault();
            dBTableModel.setDBColumn(n2++, dBColumn);
        }
        return dBTableModel;
    }

    private void addFileData(int n, int n2, File file) {
        try {
            File file2 = file.getCanonicalFile();
            String string = (file2.canRead() ? "r" : "-") + (file2.canWrite() ? "w" : "-") + (file2.isHidden() ? "h" : "-");
            String string2 = HybsSystem.getDate(file2.lastModified(), "yyyyMMddHHmmss");
            String[] stringArray = new String[SELECT.length + this.addClms.length];
            stringArray[0] = String.valueOf(n2);
            stringArray[1] = file2.isFile() ? "F" : "D";
            stringArray[2] = file2.getParent();
            stringArray[3] = file2.getName();
            stringArray[4] = string2;
            stringArray[5] = String.valueOf(file2.length());
            stringArray[6] = string;
            int n3 = SELECT.length;
            for (int i = 0; i < this.addClms.length; ++i) {
                stringArray[n3++] = this.valClms[i];
            }
            this.table.addColumnValues(stringArray);
        }
        catch (IOException iOException) {
            String string = "\u6b63\u5f0f\u306a\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + file + "]" + " ROW=[" + n + "]" + HybsSystem.CR + iOException.getMessage();
            throw new HybsSystemException(string, iOException);
        }
    }

    public void setFrom(String string) {
        char c;
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null && (c = string2.charAt(string2.length() - 1)) != '/' && c != '\\') {
            string2 = string2 + "/";
        }
        string2 = StringUtil.urlAppend((String)this.from, (String)string2);
        string2 = StringUtil.urlAppend((String)string2, (String)".");
        this.from = HybsSystem.url2dir(string2);
    }

    public void setMulti(String string) {
        this.multi = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.multi);
    }

    public void setLevel(String string) {
        this.level = StringUtil.nval((String)this.getRequestParameter(string), (int)this.level);
    }

    public void setOrderBy(String string) {
        this.orderBy = StringUtil.nval((String)this.getRequestParameter(string), (String)this.orderBy);
        if (this.orderBy != null && !this.check(this.orderBy, SELECT)) {
            String string2 = "\u6307\u5b9a\u306e orderBy \u306f\u3001\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + HybsSystem.CR + "orderBy=[" + this.orderBy + "] " + HybsSystem.CR + StringUtil.array2csv((String[])SELECT) + HybsSystem.CR;
            throw new HybsSystemException(string2.toString());
        }
    }

    public void setDesc(String string) {
        this.desc = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.desc);
    }

    public void setAddClms(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null && string2.length() > 0) {
            this.addClms = StringUtil.csv2Array((String)string2);
        }
    }

    public void setUseUpdateClms(String string) {
        this.useUpdateClms = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useUpdateClms);
    }

    public void setFileType(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fileType);
        if (string2 != null && !"DIR".equalsIgnoreCase(string2) && !"FILE".equalsIgnoreCase(string2)) {
            String string3 = "\u3053\u306e\u3001fileType \u5c5e\u6027\u306b\u306f\u3001DIR,FILE \u4ee5\u5916\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002[" + string2 + "]";
            throw new HybsSystemException(string3);
        }
        this.fileType = string2;
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("multi", (Object)this.multi).println("level", (Object)this.level).println("from", (Object)this.from).fixForm().toString() + HybsSystem.CR + super.toString();
    }
}

