/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Shell;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public class ReportPrint {
    private final int TIMEOUT = HybsSystem.sysInt("REPORT_DAEMON_TIMEOUT");
    private static final String CR = HybsSystem.CR;
    private final StringBuilder errMsg = new StringBuilder();
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String PRTID;
    private String PRTNM;
    private final String programFile;
    private final String htmlDir;
    private final String modelFile;
    private final String pdfFile;
    private final String DMN_GRP;
    private final boolean DEBUG;
    private String shellCmd = null;
    private static final String GE55_SELECT = "SELECT PRTNM,SYSTEM_ID FROM GE55 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  PRTID = ?";
    private static final int GE55_PRTNM = 0;
    private static final int GE55_SYSTEM_ID = 1;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    public ReportPrint(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.PRTID = string3;
        this.programFile = string4;
        this.htmlDir = string5;
        this.modelFile = string6;
        this.pdfFile = string7;
        this.DMN_GRP = string8;
        this.DEBUG = bl;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ReportPrint", this.YKNO, this.PRTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean execute() {
        boolean bl;
        System.out.print("ReportPrint Started ... ");
        try {
            bl = this.initialDataSet();
            if (bl) {
                System.out.print("INIT,");
            }
            if (bl && (bl = this.makeShellCommand())) {
                System.out.print("SHELL,");
            }
            if (bl && (bl = this.programRun())) {
                System.out.print("RUN,");
            }
        }
        catch (RuntimeException runtimeException) {
            this.errMsg.append("ReportPrint Execute Error! ").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append(StringUtil.stringStackTrace((Throwable)runtimeException));
            this.errMsg.append(CR);
            bl = false;
        }
        System.out.println("End.");
        return bl;
    }

    private boolean initialDataSet() {
        if (this.PRTID == null) {
            this.errMsg.append("PRTID columns does not exist in GE55 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("PRTID=[").append(this.PRTID).append("]");
            this.errMsg.append(CR);
            return false;
        }
        String[] stringArray = new String[]{this.SYSTEM_ID, this.PRTID};
        String[][] stringArray2 = DBUtil.dbExecute((String)GE55_SELECT, (String[])stringArray, (ApplicationInfo)this.appInfo);
        if (stringArray2 == null || stringArray2.length == 0) {
            this.errMsg.append("Data does not exist in GE55 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("PRTID=[").append(this.PRTID).append("]");
            this.errMsg.append(CR);
            return false;
        }
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray2[i][1])) continue;
            n = i;
            break;
        }
        this.PRTNM = StringUtil.nval((String)stringArray2[n][0], (String)this.PRTNM);
        if (this.DEBUG) {
            System.out.println("SYSTEM_ID   =" + this.SYSTEM_ID);
            System.out.println("YKNO        =" + this.YKNO);
            System.out.println("PRTID       =" + this.PRTID);
            System.out.println("PRTNM       =" + this.PRTNM);
            System.out.println("programFile =" + this.programFile);
            System.out.println("htmlDir     =" + this.htmlDir);
            System.out.println("pdfFile     =" + this.pdfFile);
            System.out.println("DMN_GRP     =" + this.DMN_GRP);
            System.out.println("GE55_SELECT =SELECT PRTNM,SYSTEM_ID FROM GE55 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  PRTID = ?");
        }
        return true;
    }

    private boolean makeShellCommand() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(this.programFile).append(" ");
        stringBuilder.append("\"").append(this.htmlDir).append(HybsSystem.FS);
        stringBuilder.append(this.YKNO).append("_*.html\" ");
        stringBuilder.append("\"").append(this.PRTNM).append("\" ");
        if (this.pdfFile != null) {
            stringBuilder.append("\"").append(this.pdfFile).append("\" ");
        } else {
            stringBuilder.append("\"").append(this.htmlDir).append(HybsSystem.FS);
            stringBuilder.append(this.YKNO).append(".xls\" ");
        }
        if (this.modelFile != null) {
            stringBuilder.append(this.modelFile).append(" ");
        } else {
            stringBuilder.append("DMY_MDL").append(" ");
        }
        stringBuilder.append(this.DMN_GRP).append(" ");
        stringBuilder.append(this.PRTID);
        this.shellCmd = stringBuilder.toString();
        System.out.println(CR + this.shellCmd + CR);
        return true;
    }

    private boolean programRun() {
        Shell shell = new Shell();
        shell.setCommand(this.shellCmd, true);
        shell.setWait(true);
        shell.setTimeout(this.TIMEOUT);
        int n = shell.exec();
        if (n != 0) {
            this.errMsg.append("Shell Command exequte Error.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append(this.shellCmd).append(CR);
            this.errMsg.append(shell.getStdoutData()).append(CR);
            this.errMsg.append(shell.getStderrData()).append(CR);
            this.errMsg.append(CR);
            return false;
        }
        return true;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }
}

