<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GANTT05"
	title	= "タスクリソース登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<og:entry command = "MODIFY" >
	<!-- 解説：CLMがNULLの場合は、メモリ上のCLM（検索条件）をセットします。 -->
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<og:columnSet command="MODIFY" columnId="PRJCODE" action="SET" value="{@PRJCODE}" />
</og:entry>

<og:message lbl="MSG0045" comment="複写処理を行います。" /><br />
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンと、EXCEL(CSV)入力リンクを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
<br />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "FGJ,PRJ_NAME"
	noWritable = "FGJ,PRJ_NAME,TASK_NAME"
	checked    = "{@checked}"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}" />

<!-- 登録データは、entry.jsp に送られます。-->
<!-- ここでは、各ページで登録方法（INSERT,UPDATE,DELETE）を指定して、entry.jspを共通で使用します。-->
<!-- 下記に示す方法は、SQL文の直接記述方式です。-->
<og:value scope="session" key="names" value="PRJCODE,TASK_ID,SEQ,RESOURCE_ID2,SU_LOAD" />
<og:value scope="session" key="SQL" >
  <jsp:text>
	INSERT INTO GF66
		(PRJCODE,TASK_ID,SEQ,RESOURCE_ID,SU_LOAD,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		([PRJCODE],[TASK_ID],[SEQ],[RESOURCE_ID2],[SU_LOAD],
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
  </jsp:text>
</og:value>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
