<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2000"
	title	= "テーブルスペース"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:link href="cube_sample.jsp"
			keys="TABLESPACE_NAME,SYSTEM_ID,TBLSYU" vals="{@TABLESPACE_NAME},{@SYSTEM_ID},{@TBLSYU}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "TABLESPACE_NAME,SYSTEM_ID,TBLSYU,NAME_JA"
	nullCheck = "SYSTEM_ID"
/>

<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select TBLSYU,TABLESPACE_NAME,NAME_JA,FILE_NAME,
				SIZE_DATA,STATUS,SYSTEM_ID,FGJ,UNIQ
		from GF01
	</jsp:text>
	<og:where>
		<og:and value = "FGJ				in  ('0','1')" 			/>
		<og:and value = "SYSTEM_ID 		=  '{@SYSTEM_ID}'" 		/>
		<og:and value = "TBLSYU			like '{@TBLSYU}%'"		/>
		<og:and value = "TABLESPACE_NAME like '{@TABLESPACE_NAME}%'" />
		<og:and value = "NAME_JA			like '{@NAME_JA}%'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,TABLESPACE_NAME,TBLSYU" />
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="NAME_JA" gamenId="GF2000" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TBLSYU,TABLESPACE_NAME"
		vals="NEW,[SYSTEM_ID],[TBLSYU],[TABLESPACE_NAME]" />
	<og:link column="TABLESPACE_NAME" gamenId="GF2010" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TBLSYU,TABLESPACE_NAME"
		vals="NEW,[SYSTEM_ID],[TBLSYU],[TABLESPACE_NAME]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />

	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GF01" /></strong></legend>
		<og:submit  value="insertGF01" lbl="INSERT" command="INSERT" />
		<og:column  name="DBID" size="5" td="no" />
	</fieldset>
	<og:hidden name="SYSTEM_ID" value="{@SYSTEM_ID}" />
	<og:submit  value="rollup"   lbl="ROLLUP" command="NEW" accesskey="D" />
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
