<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2041"
	title	= "テーブル関連"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TABLE_NAME_L,CLM_L,TABLE_NAME_R,CLM_R"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.TBLSYU,A.TABLE_NAME_L,A.CLM_L,B.NAME_JA NAME_JA_L,
			A.TABLE_NAME_R,A.CLM_R,C.NAME_JA NAME_JA_R,A.SEQNO,A.JOINTYPE,A.FGJ,A.SYSTEM_ID,A.UNIQ
		from GF08 A
		left outer join GF05 B
		on		A.SYSTEM_ID    = B.SYSTEM_ID
		and		A.TBLSYU       = B.TBLSYU
		and		A.TABLE_NAME_L = B.TABLE_NAME
		and		A.CLM_L        = B.CLM
		and		A.FGJ          = B.FGJ
		left outer join GF05 C
		on		A.SYSTEM_ID    = C.SYSTEM_ID
		and		A.TBLSYU       = C.TBLSYU
		and		A.TABLE_NAME_R = C.TABLE_NAME
		and		A.CLM_R        = C.CLM
		and		A.FGJ          = C.FGJ
	</jsp:text>
	<og:where>
		<og:and value = "A.FGJ          in   ('0','1')"           />
		<og:and value = "A.SYSTEM_ID    =    '{@SYSTEM_ID}'"      />
		<og:and value = "A.TBLSYU       =    '{@TBLSYU}'"         />
		<og:and value = "A.TABLE_NAME_L like '{@TABLE_NAME_L}%'"  />
		<og:and value = "A.CLM_L        like '{@CLM_L}%'"         />
		<og:and value = "A.TABLE_NAME_R like '{@TABLE_NAME_R}%'"  />
		<og:and value = "A.CLM_R        like '{@CLM_R}%'"         />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.TBLSYU,A.TABLE_NAME_L,A.TABLE_NAME_R,A.SEQNO" />
</og:query>

<og:columnEditor columns="NAME_JA_L,NAME_JA_R" label="NAME_JA" />
<og:columnEditor columns="TABLE_NAME_L,CLM_L,TABLE_NAME_R,CLM_R,SEQNO,JOINTYPE,TBLSYU,SYSTEM_ID" must="true" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />
</og:writeCheck>
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
