/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBTableModelImpl;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.ResourceManager;

public class DBTableModelEditor
extends DBTableModelImpl {
    private static final String JS = "__";
    private static final DecimalFormat FORMAT = new DecimalFormat("0.#########");
    private int rowCountColumn = -1;
    private DBEditConfig config;

    public void create(ResultSet resultSet, int n, int n2, ResourceManager resourceManager, DBEditConfig dBEditConfig) throws SQLException {
        if (resultSet == null || dBEditConfig == null || resourceManager == null) {
            String string = "DBTableModel\u307e\u305f\u306f\u3001DBEditConfig\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        this.config = dBEditConfig;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        if (dBEditConfig.useGroup() || dBEditConfig.useSubTotal() || dBEditConfig.useTotal() || dBEditConfig.useGrandTotal()) {
            this.rowCountColumn = n3++;
        }
        this.init(n3);
        DBColumn[] dBColumnArray = new DBColumn[this.numberOfColumns];
        int[] nArray = new int[this.numberOfColumns];
        boolean[] blArray = new boolean[this.numberOfColumns];
        boolean[] blArray2 = new boolean[this.numberOfColumns];
        boolean[] blArray3 = new boolean[this.numberOfColumns];
        boolean[] blArray4 = new boolean[this.numberOfColumns];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            String string = null;
            if (i != this.rowCountColumn) {
                string = resultSetMetaData.getColumnLabel(i + 1).toUpperCase(Locale.JAPAN);
                nArray[i] = resultSetMetaData.getColumnType(i + 1);
                dBColumnArray[i] = resourceManager.getDBColumn(string);
                if (dBColumnArray[i] == null) {
                    LabelData labelData = resourceManager.getLabelData(string);
                    dBColumnArray[i] = DBTableModelUtil.makeDBColumn(string, labelData, resultSetMetaData, i, resourceManager.getLang());
                }
            } else {
                string = "rowCount";
                dBColumnArray[i] = resourceManager.makeDBColumn(string);
            }
            this.setDBColumn(i, dBColumnArray[i]);
            blArray[i] = dBEditConfig.isSumClm(string);
            blArray2[i] = dBEditConfig.isGroupClm(string);
            blArray3[i] = dBEditConfig.isSubTotalClm(string);
            blArray4[i] = dBEditConfig.isTotalClm(string);
        }
        if (dBEditConfig.useGroup()) {
            this.addGroupRows(resultSet, nArray, n, n2, blArray, blArray2);
        } else {
            this.addPlainRows(resultSet, nArray, n, n2);
        }
        if (this.getRowCount() > 0 && dBEditConfig.useOrderBy()) {
            this.sort();
        }
        if (this.getRowCount() > 0 && !this.isOverflow() && (dBEditConfig.useSubTotal() || dBEditConfig.useTotal() || dBEditConfig.useGrandTotal())) {
            this.addTotalRows(n2, resourceManager, blArray, blArray2, blArray3, blArray4);
        }
    }

    private void addGroupRows(ResultSet resultSet, int[] nArray, int n, int n2, boolean[] blArray, boolean[] blArray2) throws SQLException {
        String[] stringArray;
        int n3;
        for (n3 = 0; n3 < n && resultSet.next(); ++n3) {
        }
        n3 = 0;
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, double[]> hashMap2 = new HashMap<String, double[]>();
        while (n3 < n2 && resultSet.next()) {
            StringBuilder stringBuilder = new StringBuilder();
            double[] object = new double[this.config.getSumClmCount()];
            stringArray = new String[this.config.getGroupClmCount()];
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.numberOfColumns; ++i) {
                if (i == this.rowCountColumn) continue;
                String string = DBUtil.getValue((ResultSet)resultSet, (int)i, (int)nArray[i]);
                if (blArray[i]) {
                    object[n4++] = Double.valueOf(string);
                }
                if (!blArray2[i]) continue;
                stringArray[n5++] = string;
                stringBuilder.append(string).append(JS);
            }
            String string = stringBuilder.toString();
            int n6 = 0;
            if (linkedHashMap.containsKey(string)) {
                double[] dArray = (double[])hashMap2.get(string);
                for (int i = 0; i < this.config.getSumClmCount(); ++i) {
                    int n7 = i;
                    object[n7] = object[n7] + dArray[i];
                }
                hashMap2.put(string, object);
                n6 = (Integer)hashMap.get(string) + 1;
            } else {
                linkedHashMap.put(string, stringArray);
                n6 = 1;
                ++n3;
            }
            hashMap2.put(string, object);
            hashMap.put(string, n6);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            stringArray = (String[])entry.getKey();
            this.addRow(blArray2, (String[])entry.getValue(), (Integer)hashMap.get(stringArray), blArray, (double[])hashMap2.get(stringArray));
        }
        if (n3 >= n2 && resultSet.next()) {
            this.setOverflow(true);
        }
    }

    private void addPlainRows(ResultSet resultSet, int[] nArray, int n, int n2) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n && resultSet.next(); ++n3) {
        }
        n3 = 0;
        while (n3 < n2 && resultSet.next()) {
            ++n3;
            String[] stringArray = new String[this.numberOfColumns];
            for (int i = 0; i < this.numberOfColumns; ++i) {
                Object object;
                stringArray[i] = i != this.rowCountColumn ? ((object = resultSet.getObject(i + 1)) == null ? "" : String.valueOf(object)) : "";
            }
            this.addColumnValues(stringArray);
        }
        if (n3 >= n2 && resultSet.next()) {
            this.setOverflow(true);
        }
    }

    private void sort() {
        DBTableModelSorter dBTableModelSorter = new DBTableModelSorter();
        dBTableModelSorter.setModel(this);
        String[] stringArray = StringUtil.csv2Array((String)this.config.getOrderByClms());
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string = stringArray[i];
            boolean bl = true;
            if (string.startsWith("!")) {
                string = string.substring(1);
                bl = false;
            }
            int n = this.getColumnNo(string);
            dBTableModelSorter.sortByColumn(n, bl);
        }
        this.data = dBTableModelSorter.data;
        this.rowHeader = dBTableModelSorter.rowHeader;
    }

    private boolean addTotalRows(int n, ResourceManager resourceManager, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, boolean[] blArray4) {
        Object[] objectArray;
        int n2;
        String string = this.config.useSubTotal() ? resourceManager.makeDBColumn("EDIT_SUBTOTAL_VALUE").getLongLabel() : null;
        String string2 = this.config.useTotal() ? resourceManager.makeDBColumn("EDIT_TOTAL_VALUE").getLongLabel() : null;
        String string3 = this.config.useGrandTotal() ? resourceManager.makeDBColumn("EDIT_GRANDTOTAL_VALUE").getLongLabel() : null;
        int n3 = this.getRowCount();
        int n4 = this.config.getSumClmCount();
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        String string4 = null;
        String string5 = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n3 < n && n2 < this.getRowCount(); ++n2) {
            int n9;
            objectArray = new double[n4];
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            int n10 = 0;
            for (n9 = 0; n9 < this.numberOfColumns; ++n9) {
                String string6 = this.getValue(n2, n9);
                if (blArray2[n9]) {
                    stringBuilder.append(string6).append(JS);
                }
                if (blArray[n9]) {
                    double d = objectArray[n10++] = string6 != null && string6.length() > 0 ? Double.valueOf(string6) : 0.0;
                }
                if (blArray3[n9]) {
                    stringBuilder2.append(string6).append(JS);
                }
                if (blArray4[n9]) {
                    stringBuilder3.append(string6).append(JS);
                }
                if (n9 != this.rowCountColumn) continue;
                n8 = string6 != null && string6.length() > 0 ? Integer.valueOf(string6) : 0;
            }
            if (this.config.useSubTotal() && string4 != null && string4.length() > 0 && !string4.equals(stringBuilder2.toString())) {
                this.addRow(blArray3, string, n5, blArray, dArray, n2);
                dArray = new double[n4];
                n5 = 0;
                ++n3;
                ++n2;
            }
            if (this.config.useTotal() && string5 != null && string5.length() > 0 && !string5.equals(stringBuilder3.toString())) {
                this.addRow(blArray4, string2, n6, blArray, dArray2, n2);
                dArray2 = new double[n4];
                n6 = 0;
                ++n3;
                ++n2;
            }
            for (n9 = 0; n9 < n4; ++n9) {
                int n11 = n9;
                dArray[n11] = dArray[n11] + objectArray[n9];
                int n12 = n9;
                dArray2[n12] = dArray2[n12] + objectArray[n9];
                int n13 = n9;
                dArray3[n13] = dArray3[n13] + objectArray[n9];
            }
            string4 = stringBuilder2.toString();
            string5 = stringBuilder3.toString();
            n9 = 1;
            if (this.config.useGroup() && this.rowCountColumn >= 0 && n8 > 0) {
                n9 = n8;
            }
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n3 < n && this.config.useSubTotal() && string4 != null) {
            this.addRow(blArray3, string, n5, blArray, dArray, n2);
            ++n3;
            ++n2;
        }
        if (n3 < n && this.config.useTotal() && string5 != null) {
            this.addRow(blArray4, string2, n6, blArray, dArray2, n2);
            ++n3;
            ++n2;
        }
        if (n3 < n && this.config.useGrandTotal() && n3 > 0) {
            objectArray = new boolean[this.numberOfColumns];
            this.addRow((boolean[])objectArray, string3, n7, blArray, dArray3, n2);
            ++n3;
            ++n2;
        }
        return n2 < this.getRowCount();
    }

    private void addRow(boolean[] blArray, String[] stringArray, int n, boolean[] blArray2, double[] dArray, int n2) {
        String[] stringArray2 = new String[this.numberOfColumns];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            String string = "";
            if (blArray[i]) {
                string = stringArray[n4++];
            }
            if (blArray2[i]) {
                string = FORMAT.format(dArray[n3++]);
            }
            if (i == this.rowCountColumn) {
                string = String.valueOf(n);
            }
            stringArray2[i] = string;
        }
        if (n2 < 0) {
            this.addColumnValues(stringArray2);
        } else {
            this.addValues(stringArray2, n2, false);
        }
    }

    private void addRow(boolean[] blArray, String[] stringArray, int n, boolean[] blArray2, double[] dArray) {
        this.addRow(blArray, stringArray, n, blArray2, dArray, -1);
    }

    private void addRow(boolean[] blArray, String string, int n, boolean[] blArray2, double[] dArray, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (!blArray[i]) continue;
            arrayList.add(string);
        }
        this.addRow(blArray, arrayList.toArray(new String[0]), n, blArray2, dArray, n2);
    }
}

