/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.opengion.fukurou.mail.MailCharset;
import org.opengion.fukurou.mail.MailCharsetFactory;
import org.opengion.fukurou.util.LogWriter;

public class MailTX {
    private static final String CR = System.getProperty("line.separator");
    public static final String MAILER = "Hayabusa Mail Ver 4.0";
    private final String charset;
    private String[] filename = null;
    private String message = null;
    private Session session = null;
    private MimeMultipart mmPart = null;
    private MimeMessage mimeMsg = null;
    private MailCharset mcSet = null;

    public MailTX(String string) {
        this(string, "ISO-2022-JP");
    }

    public MailTX(String string, String string2) {
        if (string == null) {
            String string3 = "host \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = "charset \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string4);
        }
        this.charset = string2;
        this.mcSet = MailCharsetFactory.newInstance(string2);
        Properties properties = new Properties();
        properties.setProperty("mail.mime.charset", string2);
        properties.setProperty("mail.mime.decodetext.strict", "false");
        properties.setProperty("mail.mime.address.strict", "false");
        properties.setProperty("mail.smtp.host", string);
        properties.setProperty("mail.smtp.localhost", string);
        properties.setProperty("mail.host", string);
        this.session = Session.getInstance((Properties)properties, null);
        this.mimeMsg = new MimeMessage(this.session);
    }

    public void sendmail() {
        try {
            this.mimeMsg.setSentDate(new Date());
            if (this.filename == null || this.filename.length == 0) {
                this.mcSet.setTextContent(this.mimeMsg, this.message);
            } else {
                this.mmPart = new MimeMultipart();
                this.mimeMsg.setContent((Multipart)this.mmPart);
                this.addMmpText(this.message);
                for (int i = 0; i < this.filename.length; ++i) {
                    this.addMmpFile(this.filename[i]);
                }
            }
            this.mimeMsg.setHeader("X-Mailer", MAILER);
            this.mimeMsg.setHeader("Content-Transfer-Encoding", this.mcSet.getBit());
            Transport.send((Message)this.mimeMsg);
        }
        catch (AddressException addressException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: ";
            throw new RuntimeException(string, messagingException);
        }
    }

    public void reset() {
        this.mimeMsg = new MimeMessage(this.session);
    }

    public void setFrom(String string) {
        try {
            if (string != null) {
                this.mimeMsg.setFrom((Address)this.getAddress(string));
            }
        }
        catch (AddressException addressException) {
            String string2 = "Address Exception: ";
            throw new RuntimeException(string2, addressException);
        }
        catch (MessagingException messagingException) {
            String string3 = "MessagingException: ";
            throw new RuntimeException(string3, messagingException);
        }
    }

    public void setTo(String[] stringArray) {
        try {
            if (stringArray != null) {
                this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])this.getAddress(stringArray));
            }
        }
        catch (AddressException addressException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: ";
            throw new RuntimeException(string, messagingException);
        }
    }

    public void setCc(String[] stringArray) {
        try {
            if (stringArray != null) {
                this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])this.getAddress(stringArray));
            }
        }
        catch (AddressException addressException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: ";
            throw new RuntimeException(string, messagingException);
        }
    }

    public void setBcc(String[] stringArray) {
        try {
            if (stringArray != null) {
                this.mimeMsg.setRecipients(Message.RecipientType.BCC, (Address[])this.getAddress(stringArray));
            }
        }
        catch (AddressException addressException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: ";
            throw new RuntimeException(string, messagingException);
        }
    }

    public void clearTo() {
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])((InternetAddress[])null));
        }
        catch (IllegalWriteException illegalWriteException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, illegalWriteException);
        }
        catch (IllegalStateException illegalStateException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, illegalStateException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: ";
            throw new RuntimeException(string, messagingException);
        }
    }

    public void clearCc() {
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])((InternetAddress[])null));
        }
        catch (IllegalWriteException illegalWriteException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, illegalWriteException);
        }
        catch (IllegalStateException illegalStateException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, illegalStateException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: ";
            throw new RuntimeException(string, messagingException);
        }
    }

    public void clearBcc() {
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.BCC, (Address[])((InternetAddress[])null));
        }
        catch (IllegalWriteException illegalWriteException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, illegalWriteException);
        }
        catch (IllegalStateException illegalStateException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, illegalStateException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: ";
            throw new RuntimeException(string, messagingException);
        }
    }

    public void setReplyTo(String[] stringArray) {
        try {
            if (stringArray != null) {
                this.mimeMsg.setReplyTo((Address[])this.getAddress(stringArray));
            }
        }
        catch (AddressException addressException) {
            String string = "Address Exception: ";
            throw new RuntimeException(string, addressException);
        }
        catch (MessagingException messagingException) {
            String string = "MessagingException: ";
            throw new RuntimeException(string, messagingException);
        }
    }

    public void setSubject(String string) {
        try {
            if (string != null) {
                this.mimeMsg.setSubject(this.mcSet.encodeWord(string));
            }
        }
        catch (AddressException addressException) {
            String string2 = "Address Exception: ";
            throw new RuntimeException(string2, addressException);
        }
        catch (MessagingException messagingException) {
            String string3 = "MessagingException: ";
            throw new RuntimeException(string3, messagingException);
        }
    }

    public void setFilename(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.filename = new String[n];
            System.arraycopy(stringArray, 0, this.filename, 0, n);
        }
    }

    public void setMessage(String string) {
        this.message = string == null ? CR : string + CR;
    }

    public void setDebug(boolean bl) {
        this.session.setDebug(bl);
    }

    private void addMmpFile(String string) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            FileDataSource fileDataSource = new FileDataSource(string);
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
            mimeBodyPart.setFileName(MimeUtility.encodeText((String)fileDataSource.getName(), (String)this.charset, (String)"B"));
            mimeBodyPart.setHeader("Content-Transfer-Encoding", "base64");
            this.mmPart.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "Multipart UnsupportedEncodingException: ";
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
        catch (MessagingException messagingException) {
            String string3 = "MessagingException: ";
            throw new RuntimeException(string3, messagingException);
        }
    }

    private void addMmpText(String string) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(string, this.charset);
            mimeBodyPart.setHeader("Content-Transfer-Encoding", this.mcSet.getBit());
            this.mmPart.addBodyPart((BodyPart)mimeBodyPart, 0);
        }
        catch (MessagingException messagingException) {
            String string2 = "MessagingException: ";
            throw new RuntimeException(string2, messagingException);
        }
    }

    private InternetAddress getAddress(String string) {
        InternetAddress internetAddress;
        int n = string.indexOf(60);
        if (n >= 0) {
            String string2 = string.substring(n + 1, string.indexOf(62)).trim();
            String string3 = string.substring(0, n).trim();
            internetAddress = this.mcSet.getAddress(string2, string3);
        } else {
            try {
                internetAddress = new InternetAddress(string);
            }
            catch (AddressException addressException) {
                String string4 = "\u6307\u5b9a\u306e\u30a2\u30c9\u30ec\u30b9\u3092\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3002adrs=" + string;
                throw new RuntimeException(string4, addressException);
            }
        }
        return internetAddress;
    }

    private InternetAddress[] getAddress(String[] stringArray) {
        InternetAddress[] internetAddressArray = new InternetAddress[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            internetAddressArray[i] = this.getAddress(stringArray[i]);
        }
        return internetAddressArray;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.mail.MailTX <from> <to> <host> <file> ....");
            return;
        }
        String string = stringArray[2];
        String string2 = "ISO-2022-JP";
        MailTX mailTX = new MailTX(string, string2);
        mailTX.setFrom(stringArray[0]);
        String[] stringArray2 = new String[]{stringArray[1]};
        mailTX.setTo(stringArray2);
        if (stringArray.length > 3) {
            object = new String[stringArray.length - 3];
            for (int i = 0; i < stringArray.length - 3; ++i) {
                object[i] = stringArray[i + 3];
            }
            mailTX.setFilename((String[])object);
        }
        mailTX.setSubject("\u30e1\u30fc\u30eb\u9001\u4fe1\u30c6\u30b9\u30c8");
        object = "\u3053\u308c\u306f\u30c6\u30b9\u30c8\u30e1\u30fc\u30eb\u3067\u3059\u3002" + CR + "\u3046\u307e\u304f\u53d7\u4fe1\u3067\u304d\u307e\u3057\u305f\u304b?" + CR;
        mailTX.setMessage((String)object);
        mailTX.sendmail();
    }
}

