/**************************************************************************/
/* GF09 ( シーケンス定義 )                                                */
/*                                                                        */
/* Created : 2011/08/31 19:04:50                                          */
/**************************************************************************/
CREATE TABLE GF09 (
   SYSTEM_ID  VARCHAR(10)                      NOT NULL      /* 10  システムID     */
 , TBLSYU     VARCHAR(1)                       NOT NULL      /* 20  テーブル種別   */
 , SEQNAME    VARCHAR(50)                      NOT NULL      /* 30  シーケンス名   */
 , INCREBY    NUMERIC(9)     DEFAULT 1         NOT NULL      /* 40  インクリメント */
 , STARTVAL   NUMERIC(9)     DEFAULT 1         NOT NULL      /* 50  開始値         */
 , MINVAL     NUMERIC(9)     DEFAULT 1         NOT NULL      /* 60  最小値         */
 , MAXVAL     NUMERIC(9)     DEFAULT 999999999 NOT NULL      /* 70  最大値         */
 , FGCYCLE    VARCHAR(1)     DEFAULT '1'       NOT NULL      /* 80  サイクルフラグ */
 , SUCACHE    NUMERIC(7)     DEFAULT 0         NOT NULL      /* 90  キャッシュ数   */
 , TABLE_NAME VARCHAR(50)                                    /* 100 テーブル名     */
 , CLM        VARCHAR(30)                                    /* 110 項目           */
 , UNIQ       BIGINT                           NOT NULL      /* 120 ユニークキー   */
 , FGJ        VARCHAR(1)     DEFAULT '1'       NOT NULL      /* 130 状態フラグ     */
 , DYSET      VARCHAR(14)                                    /* 140 登録日時       */
 , PGSET      VARCHAR(10)                                    /* 150 作成PG         */
 , PGPSET     VARCHAR(10)                                    /* 160 作成親PG       */
 , USRSET     VARCHAR(10)                                    /* 170 作成社員       */
 , DYUPD      VARCHAR(14)                                    /* 180 更新日時       */
 , PGUPD      VARCHAR(10)                                    /* 190 更新PG         */
 , PGPUPD     VARCHAR(10)                                    /* 200 更新親PG       */
 , USRUPD     VARCHAR(10)                                    /* 210 更新者         */
);

CREATE SEQUENCE GF09S00 ;


CREATE TRIGGER GF09T00 FOR GF09
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF09S00,1 );
  END; 


