<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2080"
	title	= "オブジェクト一覧"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,OBJ_NAME"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" maxRowCount="{@maxRowCount}" quotCheck="false" >
  <jsp:text>
	select SYSTEM_ID,TBLSYU,OBJ_NAME,SEQNO,CLM ,CLS_NAME,USE_LENGTH,
			TABLE_NAME,MAX_LENGTH,CLM_NAME,FGJ,UNIQ
	from GF81
  </jsp:text>
	<og:where>
		<og:and value="SYSTEM_ID	=    '{@SYSTEM_ID}'"	/>
		<og:and value="TBLSYU		=    '{@TBLSYU}'"		/>
		<og:and value="OBJ_NAME		like '{@OBJ_NAME}%'"	/>
		<og:and value="TABLE_NAME	like '{@TABLE_NAME}%'"	/>
		<og:and value="CLM			like '{@CLM}%'"	/>
		<og:and value="CLS_NAME		like '{@CLS_NAME}%'"	/>
	</og:where>
	<og:appear startKey="order by" value="{@ORDER_BY}"
				defaultVal="TBLSYU,OBJ_NAME,TABLE_NAME" />
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GF81" /></strong></legend>
		<og:column  name="DBID"		size="5" td="no" />
		<og:column  name="TBLSYU" defaultVal="2" addNoValue="false" td="no" />
		<og:submit  value="directGF81" lbl="DIRECT" command="INSERT" />
	</fieldset>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ,FGJ"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
