/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGElement;

/**
 * result.jspの&ltog:view&gtタグを作成します。<br />
 * 
 * ●使用例<br />
 * 		JspConvertEntity e = new JspConvertEntity();<br />
 * 		e.setTableName("GF92");<br />
 * 		e.setColumnName("CLM");<br />
 * 		List< JspConvertEntity> a = new ArrayList< JspConvertEntity>();<br />
 * 		a.add( e );<br />
 * 		Map< String , List< JspConvertEntity> > m = new Map< String , List< JspConvertEntity > >();<br />
 * 		m.put( "RESULT", a );<br />
 * 		JspCreate  j = JspCreateFactory.newInstance( "QUERY",m );<br />
 * 		j.execute("&ltog:view /&gt");
 * 
 * @author Takeshi.Takada
 *
 */
public class JspCreate_VIEW extends AbstractJspCreate {
	private List<JspConvertEntity> RESULT_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 * 
	 * 内部で使用する JspConvertEntity の List のマップを受け取り、初期化を行います。
	 * 
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、名前空間指定無しに変更します。
	 * 
	 * @param master Map<String,List<JspConvertEntity>>
	 */
	@Override
	protected void init( final Map<String,List<JspConvertEntity>> master ) {
		RESULT_ROWS	= master.get( "RESULT" );
//		IS_NULL = (RESULT_ROWS == null || RESULT_ROWS.isEmpty() );
		IS_NULL = !isNotEmpty( RESULT_ROWS );
//		KEY  = "og:view";
		KEY  = ":view";		// 5.2.1.0 (2010/10/01) 名前空間指定無し
		NAME = "result";
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 * 
	 * @og.rev 5.2.1.0 (2010/10/01) メソッドの引数を、OGAttributes から OGElement に変更します。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、引数を使用するように変更します。
	 * 
	 * @param ele OGElement エレメントオブジェクト
	 * @param nameSpace String このドキュメントのnameSpace( og とか mis とか )
	 * @return String 変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
		if( IS_NULL ) { return ""; }

		String ns = (nameSpace.length() == 0) ? "" : nameSpace + ":" ;	// 5.2.1.0 (2010/10/01) 名前空間

		// TODO Auto-generated method stub
		//書き出す文字列を作成開始。
		StringBuilder sbTub = new StringBuilder();

		List< String > no_displays = new ArrayList< String >();
		for(JspConvertEntity display : RESULT_ROWS){
			//Select句の情報を作成
			if ( display.getRemarks() == null || (display.getRemarks()!= null && display.getRemarks().trim().length() == 0 )) {
				no_displays.add( display.getColumnName() );
			}
		}
//		sbTub.append( "<og:view" ).append( CR );
		sbTub.append( "<" ).append( ns ).append( "view" ).append( CR );
		sbTub.append( "\tviewFormType = \"HTMLTable\"" ).append( CR );
		sbTub.append( "\tcommand		= \"{@command}\"" ).append( CR );
//		if ( no_displays.size() > 0 ) { 
		if ( ! no_displays.isEmpty() ) { 
			sbTub.append( "\tnoDisplay	= \"").append(chainChar( no_displays ,",") ).append("\"" ).append( CR );
		}
		sbTub.append( "/>" ).append( CR );

		return sbTub.toString();
	}
}
