/**************************************************************************/
/* GEA06 ( データロールマスタ )                                           */
/*                                                                        */
/* Created : 2011/12/17 09:07:43                                          */
/**************************************************************************/
CREATE TABLE GEA06 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , DROLE     VARCHAR2(20)                 NOT NULL      /* 20  データロール */
 , CLM       VARCHAR2(30)                 NOT NULL      /* 30  項目         */
 , CVALUE    VARCHAR2(200)                NOT NULL      /* 40  値           */
 , VALCDTN   VARCHAR2(10)                 NOT NULL      /* 50  条件         */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 60  ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 70  状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 80  登録日時     */
 , PGSET     VARCHAR2(10)                               /* 90  作成PG       */
 , PGPSET    VARCHAR2(10)                               /* 100 作成親PG     */
 , USRSET    VARCHAR2(10)                               /* 110 作成社員     */
 , DYUPD     VARCHAR2(14)                               /* 120 更新日時     */
 , PGUPD     VARCHAR2(10)                               /* 130 更新PG       */
 , PGPUPD    VARCHAR2(10)                               /* 140 更新親PG     */
 , USRUPD    VARCHAR2(10)                               /* 150 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA06S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA06T00 
BEFORE INSERT ON GEA06
FOR EACH ROW 
BEGIN 
SELECT GEA06S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

