/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public class ProgramRun {
    private final StringBuilder errMsg = new StringBuilder();
    private static final String CR = HybsSystem.CR;
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String LISTID;
    private final boolean DEBUG;
    private String sqlCmd = null;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    public ProgramRun(String string, String string2, String string3, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.LISTID = string3;
        this.DEBUG = bl;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ProgramRun", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean execute() {
        boolean bl;
        System.out.print("ProgramRun [" + this.SYSTEM_ID + "]... ");
        try {
            bl = this.makeSQLCommand();
            if (bl) {
                System.out.print(" MK SQL,");
            }
            if (bl && (bl = this.programRun())) {
                System.out.print(" PG RUN,");
            }
            System.out.println(" End.");
        }
        catch (Throwable throwable) {
            this.errMsg.append("ProgramRun Execute Error! ").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append(StringUtil.stringStackTrace((Throwable)throwable));
            this.errMsg.append(CR);
            bl = false;
        }
        return bl;
    }

    private boolean makeSQLCommand() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("{ call ").append(this.LISTID);
        stringBuilder.append("P.").append(this.LISTID);
        stringBuilder.append("( ?,?,?,? ) }");
        this.sqlCmd = stringBuilder.toString();
        if (this.DEBUG) {
            System.out.println();
            System.out.println(this.sqlCmd);
        }
        return true;
    }

    private boolean programRun() {
        String[] stringArray = new String[]{"ProgRUN", this.YKNO};
        String[] stringArray2 = DBUtil.dbCallExecute((String)this.sqlCmd, (String[])stringArray, (ApplicationInfo)this.appInfo);
        boolean bl = false;
        if (stringArray2 != null && stringArray2.length == 2) {
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            if ("0".equals(string)) {
                bl = true;
            } else {
                this.errMsg.append("PL/SQL=[").append(this.sqlCmd).append("] ");
                this.errMsg.append("YKNO=[").append(this.YKNO).append("] ");
                this.errMsg.append("LISTID=[").append(this.LISTID).append("] ");
                this.errMsg.append(string).append(":").append(string2);
                this.errMsg.append(CR);
                LogWriter.log((String)this.errMsg.toString());
            }
        }
        return bl;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }
}

