/**************************************************************************/
/* GE80 ( FAQテーブル )                                                   */
/*                                                                        */
/* Created : 2012/01/25 19:01:58                                          */
/**************************************************************************/
CREATE TABLE GE80 (
   UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 10  ユニークキー   */
 , SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 20  システムID     */
 , SYSCODE   VARCHAR2(20)      DEFAULT '*' NOT NULL      /* 30  システムコード */
 , QANO      VARCHAR2(20)                  NOT NULL      /* 40  質問番号       */
 , NMBNRI    VARCHAR2(50)                                /* 50  分類名         */
 , KNRNGUI   VARCHAR2(200)                               /* 60  関連画面ID     */
 , TITLE     VARCHAR2(300)                               /* 70  タイトル       */
 , NAIYO     VARCHAR2(4000)                              /* 80  内容           */
 , SEQNO     NUMBER(7)         DEFAULT 0   NOT NULL      /* 90  表示順         */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 100 状態フラグ     */
 , DYSET     VARCHAR2(14)                                /* 110 登録日時       */
 , PGSET     VARCHAR2(10)                                /* 120 作成PG         */
 , PGPSET    VARCHAR2(10)                                /* 130 作成親PG       */
 , USRSET    VARCHAR2(10)                                /* 140 作成社員       */
 , DYUPD     VARCHAR2(14)                                /* 150 更新日時       */
 , PGUPD     VARCHAR2(10)                                /* 160 更新PG         */
 , PGPUPD    VARCHAR2(10)                                /* 170 更新親PG       */
 , USRUPD    VARCHAR2(10)                                /* 180 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE80S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE80T00 
BEFORE INSERT ON GE80
FOR EACH ROW 
BEGIN 
SELECT GE80S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

