/**************************************************************************/
/* GF27 ( 逆引きマニュアル )                                              */
/*                                                                        */
/* Created : 2012/03/27 19:47:25                                          */
/**************************************************************************/
CREATE TABLE GF27 (
   SEQ          NUMERIC(7)      DEFAULT 0   NOT NULL      /* 10  順           */
 , TITLE        VARCHAR(300)                NOT NULL      /* 20  タイトル     */
 , ANSWER       VARCHAR(200)                              /* 30  回答         */
 , DIFFICULTY   VARCHAR(1)                                /* 40  難易度       */
 , PARTNO       NUMERIC(2)                                /* 50  部番号       */
 , PART         VARCHAR(100)                              /* 60  部           */
 , CHAPTERNO    NUMERIC(2)                                /* 70  章番号       */
 , CHAPTER      VARCHAR(100)                              /* 80  章           */
 , BIG_CLASS    VARCHAR(100)                              /* 90  大分類       */
 , INSIDE_CLASS VARCHAR(100)                              /* 100 中分類       */
 , KEYWORD      VARCHAR(200)                              /* 110 キーワード   */
 , CONTENTS     BLOB                                      /* 120 内容         */
 , SAMPLE       BLOB                                      /* 130 サンプル     */
 , URL          VARCHAR(200)                              /* 140 URL          */
 , UNIQ         BIGINT                      NOT NULL      /* 800 ユニークキー */
 , FGJ          VARCHAR(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET        VARCHAR(14)                               /* 820 登録日時     */
 , PGSET        VARCHAR(10)                               /* 830 作成PG       */
 , PGPSET       VARCHAR(10)                               /* 840 作成親PG     */
 , USRSET       VARCHAR(10)                               /* 850 作成社員     */
 , DYUPD        VARCHAR(14)                               /* 860 更新日時     */
 , PGUPD        VARCHAR(10)                               /* 870 更新PG       */
 , PGPUPD       VARCHAR(10)                               /* 880 更新親PG     */
 , USRUPD       VARCHAR(10)                               /* 890 更新者       */
);

CREATE SEQUENCE GF27S00 ;


CREATE TRIGGER GF27T00 FOR GF27
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF27S00,1 );
  END; 


