<!-- PostgreSQL  -->
<og:equals val1="{@DBF.NAME}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select CONSTRAINT_NAME AS INDEX_NAME,TABLE_NAME,'' AS TABLESPACE_NAME,CONSTRAINT_NAME AS NAME_JA,
				(CASE WHEN CONSTRAINT_NAME LIKE '%_pkey' THEN '1' ELSE '2' END) AS INDTYPE,
				'0' AS INITIAL_AUTO,
				'0' AS INITIAL_EXTENT,
				'0' AS NEXT_EXTENT,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from information_schema.key_column_usage
		where CONSTRAINT_SCHEMA = 'public'
	<og:where startKey="and">
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}%'"  />
	</og:where>
		group by CONSTRAINT_NAME,TABLE_NAME
		order by CONSTRAINT_NAME,TABLE_NAME
  </og:query>
</og:equals>

<!-- ORACLE  -->
<og:equals val1="{@DBF.NAME}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select INDEX_NAME,TABLE_NAME,TABLESPACE_NAME,INDEX_NAME AS NAME_JA,
				(CASE UNIQUENESS WHEN 'UNIQUE' THEN '1' ELSE '2' END) AS INDTYPE,
				'0' AS INITIAL_AUTO,
				INITIAL_EXTENT/1024 AS INITIAL_EXTENT,
				NEXT_EXTENT/1024 AS NEXT_EXTENT,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_INDEXES
		where exists ( select 'X' from USER_TABLES
						where USER_TABLES.TABLE_NAME = USER_INDEXES.TABLE_NAME
					)
		and   INSTR(TABLE_NAME,'$') < 1
		and   INSTR(INDEX_NAME,'$') < 1
	<og:where startKey="and">
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}%'"  />
	</og:where>
		order by TABLE_NAME,INDEX_NAME
  </og:query>
</og:equals>
