/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

// import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractDBType;

/**
 * DATA_DEFAULT カラムで、内容の整合性を整えます。
 *
 * DATA_DEFAULT(初期値)カラムは、データベース上に設定されていますが、
 * DB定義スクリプトや、データベースの種類によって、本来必要な形式で
 * 取得できないときがあります。
 * ここでは、初期値の後ろに コメントがある場合は、削除し、
 * データそのものに、シングルクオートをはずします。
 * 定義情報出力時には、カラムの属性（数字型、文字型）
 * また、postgreSQL 対応として、::属性情報が入るので、削除します。
 * シーケンス使用時にも、nextval が自動的にセットさえばすが、
 * 削除します。
 *
 * このクラスは、valueAction メソッドで、action="VALSET" でのみ
 * 動作します。
 *
 * @og.group データ属性
 * @og.rev 5.1.3.0 (2010/02/01) 新規作成
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class DBType_DD extends AbstractDBType {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.1.3.0 (2010/02/01)" ;

	/**
	 * action で指定されたコマンドを実行して、値の変換を行います。
	 * oldValue(旧データ)は、元のDBTableModelに設定されていた値です。通常は、
	 * この値を使用してカラム毎に変換を行います。newValue(新データ)は、引数で
	 * 指定された新しい値です。この値には、パラメータを指定して変換方法を
	 * 制御することも可能です。
	 * 指定のアクションがカラムで処理できない場合は、エラーになります。
	 *
	 * @og.rev 5.1.3.0 (2010/02/01) 新規追加
	 *
	 * @param   action アクションコマンド
	 * @param   oldValue 入力データ（旧データ）
	 * @param   newValue 入力データ（新データ）
	 * @return	実行後のデータ
	 */
	public String valueAction( final String action,final String oldValue,final String newValue ) {
		if( "VALSET".equals( action ) ) {
			String val = StringUtil.rTrim( oldValue ) ;

			if( val != null && val.length() > 0 ) {
				// 共通：シングルクオートはずし
				int pos1 = val.indexOf( "'",1 );
				if( pos1 > 1 ) { val = val.substring( 1,pos1 ); }
				// 共通：初期値に /* */ コメントが入ることがあるので、削除
				int pos2 = val.indexOf( "/*" );
				if( pos2 > 0 ) { val = val.substring( 0,pos2 ); }

				// postgreSQL 対応：属性情報が入るので、削除
				int pos3 = val.indexOf( "::" );
				if( pos3 > 0 ) { val = val.substring( 0,pos3 ); }
				// postgreSQL 対応：属性情報が入るので、削除
				// ＃ oldValue で判断しているのは、val は、先に色々と加工している為
				if( oldValue.startsWith( "nextval" ) ) { val = ""; }
			}

			return val ;
		}
		else {
			return super.valueAction( action,oldValue,newValue ) ;
		}
	}
}
