#!/bin/sh
# /***************************************************************************/
# /*  このファイルでは、openGionを起動するための環境変数を設定します。       */
# /*  必要に応じて各種パラメーターを変更します。                             */
# /***************************************************************************/

# /***************************************************************************/
# /*  DB接続先を指定します。(設定必須)                                       */
# /***************************************************************************/
export REALM_DRIVER=oracle.jdbc.driver.OracleDriver
export REALM_URL=jdbc:oracle:thin:@localhost:1521:TNKR
export REALM_NAME=GF
export REALM_PASSWORD=GF
# /***************************************************************************/
# /*  HTTP,AJP,シャットダウンポートを指定します。(任意設定)                  */
# /***************************************************************************/
export SHUTDOWN_PORT=8006
export CONNECTOR_PORT=8824
export AJP_PORT=8010

# /***************************************************************************/
# /*  Java・Tomcat・OpenOfficeのバージョンを設定します。(標準推奨)           */
# /***************************************************************************/
export JDK_VER=jdk160_14
export TOMCAT_VER=tomcat6.0.18
export OPENOFFICE_VER=openoffice3.1

# /***************************************************************************/
# /*  コンテキスト名、及び自動インストールタイプを指定します。(標準推奨)     */
# /*   DEV_CTXT  : 開発用コンテスト                                          */
# /*   CORE_CTXT : コアシステム用コンテキスト                                */
# /*   INSTALL_CONTEXTS : 初回起動時にDB環境のインストールを行うコンテキスト */
# /*                      [$CORE_CTXT,$DEV_CTXT] :Full版(含開発環境)         */
# /*                      [$CORE_CTXT]           :コアシステムのみ           */
# /***************************************************************************/
export DEV_CTXT=gf
export CORE_CTXT=ge
# export INSTALL_CONTEXTS=$CORE_CTXT,$DEV_CTXT

# /***********************************************************************/
# /*  Javaの設定です                                                     */
# /*  メモリの使用量等を指定します                                       */
# /***********************************************************************/
export JAVA_OPTS="-Xms64m -Xmx512m"

. $(cd $(dirname $0);pwd)/const.sh
